/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.permissionsxml;

import com.sun.enterprise.security.permissionsxml.BasePermissionsProcessor;
import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.GlobalPolicyUtil;
import java.net.MalformedURLException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.deployment.DeploymentContext;

public class EarEEPermissionsProcessor
extends BasePermissionsProcessor {
    private static final Map<CommponentType, PermissionCollection> compTypeToEEGrantedPermissions = new HashMap<CommponentType, PermissionCollection>();

    public EarEEPermissionsProcessor(DeploymentContext dc) throws SecurityException {
        super(CommponentType.ear, dc);
        try {
            this.convertEEPermissionPaths(CommponentType.ejb);
            this.convertEEPermissionPaths(CommponentType.war);
            this.convertEEPermissionPaths(CommponentType.rar);
            this.convertEEPermissionPaths(CommponentType.car);
            this.combineAllEEPermisssonsForEar();
        }
        catch (MalformedURLException e) {
            throw new SecurityException(e);
        }
    }

    public PermissionCollection getAdjustedEEPermission(CommponentType type) {
        return compTypeToEEGrantedPermissions.get((Object)type);
    }

    public Map<CommponentType, PermissionCollection> getAllAdjustedEEPermission() {
        return compTypeToEEGrantedPermissions;
    }

    private void convertEEPermissionPaths(CommponentType cmpType) throws MalformedURLException {
        PermissionCollection defWarPc = GlobalPolicyUtil.getEECompGrantededPerms(cmpType);
        PermissionCollection eePc = EarEEPermissionsProcessor.processPermisssonsForPath(defWarPc, this.context);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Revised permissions = " + eePc);
        }
        compTypeToEEGrantedPermissions.put(cmpType, eePc);
    }

    private PermissionCollection combineAllEEPermisssonsForEar() {
        if (compTypeToEEGrantedPermissions == null) {
            return null;
        }
        Permissions allEEPermissions = new Permissions();
        this.addPermissions(allEEPermissions, this.getAdjustedEEPermission(CommponentType.war));
        this.addPermissions(allEEPermissions, this.getAdjustedEEPermission(CommponentType.ejb));
        this.addPermissions(allEEPermissions, this.getAdjustedEEPermission(CommponentType.rar));
        compTypeToEEGrantedPermissions.put(CommponentType.ear, allEEPermissions);
        return allEEPermissions;
    }

    private void addPermissions(Permissions combinedPermissions, PermissionCollection toAdd) {
        if (toAdd == null) {
            return;
        }
        Enumeration<Permission> permissionsToAdd = toAdd.elements();
        while (permissionsToAdd.hasMoreElements()) {
            combinedPermissions.add(permissionsToAdd.nextElement());
        }
    }
}

