/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.permissionsxml;

import com.sun.enterprise.security.integration.DDPermissionsLoader;
import com.sun.enterprise.security.permissionsxml.CommponentType;
import com.sun.enterprise.security.permissionsxml.GlobalPolicyUtil;
import com.sun.enterprise.security.permissionsxml.ModuleEEPermissionsProcessor;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class SetPermissionsAction
implements PrivilegedExceptionAction<Object> {
    private final CommponentType type;
    private final DeploymentContext context;
    private final ClassLoader classLoader;

    public SetPermissionsAction(CommponentType type, DeploymentContext deploymentContext, ClassLoader classLoader) {
        this.type = type;
        this.context = deploymentContext;
        this.classLoader = classLoader;
    }

    @Override
    public Object run() throws SecurityException {
        SetPermissionsAction.processModuleDeclaredAndEEPermissions(this.type, this.context, this.classLoader);
        return null;
    }

    private static void processModuleDeclaredAndEEPermissions(CommponentType type, DeploymentContext context, ClassLoader classloader) throws SecurityException {
        if (System.getSecurityManager() != null) {
            if (!(classloader instanceof DDPermissionsLoader)) {
                return;
            }
            if (!(context instanceof ExtendedDeploymentContext)) {
                return;
            }
            DDPermissionsLoader permissionsLoader = (DDPermissionsLoader)classloader;
            if (((ExtendedDeploymentContext)context).getParentContext() == null) {
                permissionsLoader.addDeclaredPermissions(GlobalPolicyUtil.getDeclaredPermissions(type, context));
            }
            permissionsLoader.addEEPermissions(SetPermissionsAction.processEEPermissions(type, context));
        }
    }

    private static PermissionCollection processEEPermissions(CommponentType type, DeploymentContext context) {
        return new ModuleEEPermissionsProcessor(type, context).getAdjustedEEPermission();
    }
}

