/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.PrincipalGroupFactory;
import com.sun.enterprise.security.SecurityContextProxy;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.common.AbstractSecurityContext;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.integration.AppServSecurityContext;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.PrincipalImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class SecurityContext
extends AbstractSecurityContext {
    private static final long serialVersionUID = -1061816185561416857L;
    private static final Logger LOGGER = SecurityLoggerInfo.getLogger();
    private static InheritableThreadLocal<SecurityContext> currentSecurityContext = new InheritableThreadLocal();
    private static SecurityContext defaultSecurityContext = SecurityContext.generateDefaultSecurityContext();
    private static AuthPermission doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");
    private boolean serverGeneratedCredentials;

    public static SecurityContext init() {
        SecurityContext securityContext = (SecurityContext)currentSecurityContext.get();
        if (securityContext == null) {
            securityContext = defaultSecurityContext;
        }
        return securityContext;
    }

    public static SecurityContext getDefaultSecurityContext() {
        return defaultSecurityContext;
    }

    public static Subject getDefaultSubject() {
        return SecurityContext.defaultSecurityContext.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Principal getDefaultCallerPrincipal() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            if (SecurityContext.defaultSecurityContext.callerPrincipal == null) {
                String guestUser = null;
                try {
                    guestUser = (String)AppservAccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            SecurityService securityService = (SecurityService)SecurityServicesUtil.getInstance().getHabitat().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
                            if (securityService == null) {
                                return null;
                            }
                            return securityService.getDefaultPrincipal();
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "NCLS-SECURITY-05038", e);
                }
                finally {
                    if (guestUser == null) {
                        guestUser = "ANONYMOUS";
                    }
                }
                SecurityContext.defaultSecurityContext.callerPrincipal = new PrincipalImpl(guestUser);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SecurityContext.defaultSecurityContext.callerPrincipal;
        }
    }

    public static void reset(SecurityContext securityContext) {
        SecurityContext.setCurrent(securityContext);
    }

    public static SecurityContext getCurrent() {
        SecurityContext securityContext = (SecurityContext)currentSecurityContext.get();
        if (securityContext == null) {
            securityContext = defaultSecurityContext;
        }
        return securityContext;
    }

    public static void setCurrent(SecurityContext securityContext) {
        if (securityContext != null && securityContext != defaultSecurityContext) {
            if (securityContext == currentSecurityContext.get()) {
                return;
            }
            if (SecurityContext.isPermittedToSetContext()) {
                currentSecurityContext.set(securityContext);
            } else {
                LOGGER.severe("NCLS-SECURITY-05050");
            }
        } else {
            currentSecurityContext.set(securityContext);
        }
    }

    public static void setUnauthenticatedContext() {
        currentSecurityContext.set(defaultSecurityContext);
    }

    public SecurityContext(String username, Subject subject) {
        Subject localSubject = this.nullSafeSubject(subject);
        this.callerPrincipal = new PrincipalImpl(username);
        this.subject = AppservAccessController.privileged(() -> {
            localSubject.getPrincipals().add(this.callerPrincipal);
            return localSubject;
        });
    }

    public SecurityContext(Subject subject) {
        Subject localSubject;
        this.subject = localSubject = this.nullSafeSubject(subject);
        this.callerPrincipal = AppservAccessController.privileged(() -> {
            Iterator<Principal> prinIter;
            Principal principal = null;
            for (Object publicCredential : localSubject.getPublicCredentials()) {
                if (!(publicCredential instanceof DistinguishedPrincipalCredential)) continue;
                DistinguishedPrincipalCredential distinguishedCredential = (DistinguishedPrincipalCredential)publicCredential;
                principal = distinguishedCredential.getPrincipal();
                break;
            }
            if (principal == null && (prinIter = localSubject.getPrincipals().iterator()).hasNext()) {
                principal = prinIter.next();
            }
            return principal;
        });
        this.postConstruct();
    }

    public SecurityContext(String username, Subject subject, String realm) {
        Subject localSubject = this.nullSafeSubject(subject);
        PrincipalGroupFactory factory = (PrincipalGroupFactory)Globals.get(PrincipalGroupFactory.class);
        if (factory != null) {
            this.callerPrincipal = factory.getPrincipalInstance(username, realm);
        }
        this.subject = localSubject;
        AppservAccessController.privileged(() -> this.subject.getPrincipals().add(this.callerPrincipal));
    }

    public SecurityContext() {
        LOGGER.fine("Default CTOR of SecurityContext called");
        this.subject = new Subject();
        this.callerPrincipal = null;
        this.setServerGeneratedCredentials();
        AppservAccessController.privileged(() -> this.subject.setReadOnly());
    }

    public boolean didServerGenerateCredentials() {
        return this.serverGeneratedCredentials;
    }

    @Override
    public Principal getCallerPrincipal() {
        return this == defaultSecurityContext ? SecurityContext.getDefaultCallerPrincipal() : this.callerPrincipal;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    public Set<Principal> getPrincipalSet() {
        return this.subject.getPrincipals();
    }

    public void postConstruct() {
        this.initDefaultCallerPrincipal();
    }

    public AppServSecurityContext newInstance(String username, Subject subject, String realm) {
        LOGGER.fine("SecurityContext: newInstance method called");
        return new SecurityContext(username, subject, realm);
    }

    public AppServSecurityContext newInstance(String username, Subject subject) {
        LOGGER.fine("SecurityContext: newInstance method called");
        return new SecurityContext(username, subject);
    }

    public void setCurrentSecurityContext(AppServSecurityContext context) {
        LOGGER.fine("SecurityContext: setCurrentSecurityContext method called");
        if (context == null) {
            SecurityContext.setCurrent(null);
            return;
        }
        if (context instanceof SecurityContext) {
            SecurityContext.setCurrent((SecurityContext)context);
            return;
        }
        throw new IllegalArgumentException("Expected SecurityContext, found " + context);
    }

    public AppServSecurityContext getCurrentSecurityContext() {
        LOGGER.fine("SecurityContext: getCurrent() method called");
        return SecurityContext.getCurrent();
    }

    public void setUnauthenticatedSecurityContext() {
        LOGGER.fine("SecurityContext: setUnauthenticatedSecurityContext method called");
        SecurityContext.setUnauthenticatedContext();
    }

    public void setSecurityContextWithPrincipal(Principal principal) {
        SecurityContext.setCurrent(this.getSecurityContextForPrincipal(principal));
    }

    public String toString() {
        return "SecurityContext[ Initiator: " + this.callerPrincipal + "Subject " + this.subject + " ]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityContext generateDefaultSecurityContext() {
        Class<SecurityContext> clazz = SecurityContext.class;
        synchronized (SecurityContext.class) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return (SecurityContext)AppservAccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return new SecurityContext();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-SECURITY-05036", e);
                // ** MonitorExit[var0] (shouldn't be in output)
            }
            return null;
        }
    }

    private static boolean isPermittedToSetContext() {
        try {
            SecurityContext.checkIsPriviledged();
            return true;
        }
        catch (SecurityException se) {
            LOGGER.log(Level.SEVERE, "NCLS-SECURITY-05048", se);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "NCLS-SECURITY-05049", t);
        }
        return false;
    }

    private static void checkIsPriviledged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            LOGGER.fine("permission check done to set SecurityContext");
            securityManager.checkPermission(doAsPrivilegedPerm);
        }
    }

    private Subject nullSafeSubject(Subject subject) {
        if (subject == null) {
            subject = new Subject();
            LOGGER.warning("NCLS-SECURITY-05052");
        }
        return subject;
    }

    private void setServerGeneratedCredentials() {
        this.serverGeneratedCredentials = true;
    }

    private void initDefaultCallerPrincipal() {
        if (this.callerPrincipal == null) {
            this.callerPrincipal = SecurityContext.getDefaultCallerPrincipal();
        }
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof SecurityContextProxy) {
            return ((SecurityContextProxy)((Object)principal)).getSecurityContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                Subject subject = new Subject();
                subject.getPrincipals().add(principal);
                return new SecurityContext(principal.getName(), subject);
            }
        });
    }
}

