/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth;

import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.certificate.OID;
import com.sun.enterprise.security.common.AppservAccessController;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.x500.X500Principal;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;

public final class WebAndEjbToJaasBridge {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();

    private WebAndEjbToJaasBridge() {
    }

    public static void login(String username, char[] password, String realmName) {
        Subject subject = new Subject();
        AppservAccessController.privileged(() -> subject.getPrivateCredentials().add(new PasswordCredential(username, password, LoginContextDriver.getValidRealm(realmName))));
        WebAndEjbToJaasBridge.login(subject, PasswordCredential.class);
    }

    public static void login(Subject subject, Class<?> credentialClass) {
        _logger.finest(() -> "Processing login with credentials of type: " + credentialClass);
        if (credentialClass.equals(PasswordCredential.class)) {
            WebAndEjbToJaasBridge.doPasswordLogin(subject);
        } else if (credentialClass.equals(X509CertificateCredential.class)) {
            WebAndEjbToJaasBridge.doX509CertificateLogin(subject);
        } else if (credentialClass.equals(AnonCredential.class)) {
            WebAndEjbToJaasBridge.doAnonymousLogin();
        } else if (credentialClass.equals(GSSUPName.class)) {
            WebAndEjbToJaasBridge.doGSSUPLogin(subject);
        } else if (credentialClass.equals(X500Principal.class)) {
            WebAndEjbToJaasBridge.doX500Login(subject, null);
        } else {
            _logger.log(Level.INFO, "NCLS-SECURITY-05019", credentialClass.toString());
            throw new LoginException("Unknown credential type, cannot login.");
        }
    }

    public static void doX500Login(Subject subject, String appModuleID) {
        WebAndEjbToJaasBridge.doX500Login(subject, "certificate", appModuleID);
    }

    public static void doX500Login(Subject subject, String realmName, String appModuleID) {
        _logger.finest(() -> String.format("doX500Login(subject=%s, realmName=%s, appModuleID=%s)", subject, realmName, appModuleID));
        String user = null;
        try {
            X500Principal x500principal = WebAndEjbToJaasBridge.getPublicCredentials(subject, X500Principal.class);
            if (x500principal == null) {
                return;
            }
            user = x500principal.getName("RFC2253", OID.getOIDMap());
            Realm realm = Realm.getInstance(realmName);
            if (realm instanceof CertificateRealm) {
                CertificateRealm certRealm = (CertificateRealm)realm;
                String jaasCtx = certRealm.getJAASContext();
                if (jaasCtx != null) {
                    new LoginContext(jaasCtx, subject, new ServerLoginCallbackHandler(user, null, appModuleID)).login();
                }
                user = certRealm.authenticate(subject, x500principal);
                LoginContextDriver.auditAuthenticate(user, realmName, true);
            } else {
                _logger.warning("NCLS-SECURITY-01050");
                WebAndEjbToJaasBridge.setSecurityContext(user, subject, realmName);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("X.500 name login succeeded for : " + user);
            }
        }
        catch (LoginException le) {
            LoginContextDriver.auditAuthenticate(user, realmName, false);
            throw le;
        }
        catch (Exception ex) {
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
    }

    public static void login(DigestCredentials digestCred) throws javax.security.auth.login.LoginException {
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(digestCred);
        try {
            LoginContextDriver.tryJaasLogin(LoginContextDriver.getJaasContext(digestCred.getRealmName()), subject);
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "NCLS-SECURITY-05046", digestCred.getUserName());
            _logger.log(Level.FINEST, "doPasswordLogin fails", e);
            LoginContextDriver.auditAuthenticate(digestCred.getUserName(), digestCred.getRealmName(), false);
            LoginContextDriver.throwLoginException(e);
        }
        WebAndEjbToJaasBridge.setSecurityContext(digestCred.getUserName(), subject, digestCred.getRealmName());
    }

    public static void loginPrincipal(String username, String realmName) {
        if (realmName == null || realmName.length() == 0) {
            realmName = Realm.getDefaultRealm();
        }
        Subject subject = new Subject();
        PrincipalImpl callerPrincipal = new PrincipalImpl(username);
        GSSUPName name = new GSSUPName(username, realmName);
        AppservAccessController.privileged(() -> {
            subject.getPrincipals().add((Principal)callerPrincipal);
            subject.getPublicCredentials().add(name);
        });
        try {
            Enumeration<String> groupNames = Realm.getInstance(realmName).getGroupNames(username);
            Set<Principal> principalSet = subject.getPrincipals();
            while (groupNames.hasMoreElements()) {
                principalSet.add((Principal)new Group(groupNames.nextElement()));
            }
        }
        catch (InvalidOperationException ex) {
            _logger.log(Level.WARNING, "NCLS-SECURITY-01150", new Object[]{username, realmName, ex.toString()});
        }
        catch (NoSuchUserException ex) {
            _logger.log(Level.WARNING, "NCLS-SECURITY-01151", new Object[]{username, realmName, ex.toString()});
        }
        catch (NoSuchRealmException ex) {
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
        WebAndEjbToJaasBridge.setSecurityContext(username, subject, realmName);
    }

    public static void logout() {
        WebAndEjbToJaasBridge.unsetSecurityContext();
    }

    private static void doPasswordLogin(Subject subject) {
        PasswordCredential passwordCredential = WebAndEjbToJaasBridge.getPrivateCredentials(subject, PasswordCredential.class);
        String user = passwordCredential.getUser();
        String realm = passwordCredential.getRealm();
        String jaasCtx = LoginContextDriver.getJaasContext(realm);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Logging in user [" + user + "] into realm: " + realm + " using JAAS module: " + jaasCtx);
        }
        try {
            LoginContextDriver.tryJaasLogin(jaasCtx, subject);
        }
        catch (Exception e) {
            _logger.log(Level.FINEST, "doPasswordLogin fails", e);
            LoginContextDriver.auditAuthenticate(user, realm, false);
            LoginContextDriver.throwLoginException(e);
        }
        LoginContextDriver.auditAuthenticate(user, realm, true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Password login succeeded for : " + user);
        }
        WebAndEjbToJaasBridge.setSecurityContext(user, subject, realm);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Set security context as user: " + user);
        }
    }

    private static void doX509CertificateLogin(Subject subject) {
        _logger.log(Level.FINE, "Processing X509 certificate login.");
        String user = null;
        String realm = "certificate";
        try {
            user = WebAndEjbToJaasBridge.getPublicCredentials(subject, X509CertificateCredential.class).getAlias();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Set security context as user: " + user);
            }
            WebAndEjbToJaasBridge.setSecurityContext(user, subject, realm);
            LoginContextDriver.auditAuthenticate(user, realm, true);
        }
        catch (LoginException le) {
            LoginContextDriver.auditAuthenticate(user, realm, false);
            throw le;
        }
    }

    private static void doAnonymousLogin() {
        SecurityContext.setUnauthenticatedContext();
        _logger.log(Level.FINE, "Set anonymous security context.");
    }

    private static void doGSSUPLogin(Subject s) {
        _logger.fine("Processing GSSUP login.");
        String user = null;
        String realm = Realm.getDefaultRealm();
        try {
            user = WebAndEjbToJaasBridge.getPublicCredentials(s, GSSUPName.class).getUser();
            WebAndEjbToJaasBridge.setSecurityContext(user, s, realm);
            LoginContextDriver.auditAuthenticate(user, realm, true);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSUP login succeeded for : " + user);
            }
        }
        catch (LoginException le) {
            LoginContextDriver.auditAuthenticate(user, realm, false);
            throw le;
        }
    }

    private static <T> T getPublicCredentials(Subject subject, Class<T> cls) {
        Set<T> credset = subject.getPublicCredentials(cls);
        Iterator iter = credset.iterator();
        if (!iter.hasNext()) {
            String credentialType = cls.toString();
            _logger.log(Level.FINER, () -> "Expected public credentials of type : " + credentialType + " but none found.");
            throw new LoginException("Expected public credential of type: " + credentialType + " but none found.");
        }
        try {
            return (T)AppservAccessController.privileged(() -> iter.next());
        }
        catch (Exception exception) {
            LoginContextDriver.throwLoginException(exception, e -> "Failed to retrieve public credential: " + e.getMessage());
            return null;
        }
    }

    private static <T> T getPrivateCredentials(Subject subject, Class<T> cls) {
        Iterator iter = AppservAccessController.privileged(() -> subject.getPrivateCredentials(cls)).iterator();
        if (!iter.hasNext()) {
            String credmsg = cls.toString();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Expected private credential of type: " + credmsg + " but none found.");
            }
            throw new LoginException("Expected private credential of type: " + credmsg + " but none found.");
        }
        try {
            return (T)AppservAccessController.privileged(() -> iter.next());
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Failed to retrieve private credential: " + e.getMessage(), e);
        }
    }

    private static void setSecurityContext(String userName, Subject subject, String realm) {
        SecurityContext.setCurrent(new SecurityContext(userName, subject, realm));
    }

    private static void unsetSecurityContext() {
        SecurityContext.setCurrent(null);
    }
}

