/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.GUILoginDialog;
import com.sun.enterprise.security.TextLoginDialog;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LoginCallbackHandler
implements CallbackHandler {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LoginCallbackHandler.class);
    private boolean isGUI;
    protected ThreadLocal<Boolean> cancelStatus = new ThreadLocal();

    public boolean getCancelStatus() {
        boolean cancelled = this.cancelStatus.get();
        this.cancelStatus.set(false);
        return cancelled;
    }

    public LoginCallbackHandler() {
        this(true);
    }

    public LoginCallbackHandler(boolean gui) {
        this.isGUI = gui;
        this.cancelStatus.set(false);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.isGUI) {
            String user = localStrings.getLocalString("login.user", "user");
            new GUILoginDialog(user, callbacks);
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof NameCallback)) continue;
                this.cancelStatus.set(((NameCallback)callbacks[i]).getName() == null);
                break;
            }
        } else {
            new TextLoginDialog(callbacks);
        }
    }
}

