/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.cli.CLIUtil;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-jacc-providers")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.jacc.provider")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=SecurityService.class, opType=RestEndpoint.OpType.GET, path="list-jacc-providers", description="list-jacc-providers")})
public class ListJaccProviders
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    @AccessRequired.To(value={"read"})
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.config = CLIUtil.chooseConfig(this.domain, this.target, report);
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        for (JaccProvider jaccProvider : this.securityService.getJaccProvider()) {
            report.getTopMessagePart().addChild().setMessage(jaccProvider.getName());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

