/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class AppservAccessController {
    private static boolean isSecMgrOff = System.getSecurityManager() == null;

    private AppservAccessController() {
    }

    public static <T> T privileged(PrivilegedAction<T> action) {
        if (isSecMgrOff) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    public static Object privileged(Runnable action) {
        if (isSecMgrOff) {
            action.run();
            return null;
        }
        return AccessController.doPrivileged(() -> {
            action.run();
            return null;
        });
    }

    public static void privilegedException(Runnable action) throws PrivilegedActionException {
        if (isSecMgrOff) {
            try {
                action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        } else {
            AccessController.doPrivileged(() -> {
                action.run();
                return null;
            });
        }
    }

    public static Object privilegedAlways(Runnable action) {
        return AccessController.doPrivileged(() -> {
            action.run();
            return null;
        });
    }

    public static <T> T privilegedAlways(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    public static Object doPrivileged(PrivilegedAction<?> action) {
        if (isSecMgrOff) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    public static Object doPrivileged(PrivilegedExceptionAction<Object> action) throws PrivilegedActionException {
        if (isSecMgrOff) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return AccessController.doPrivileged(action);
    }
}

