/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.dynamodb.admin;

import fish.payara.microprofile.config.extensions.dynamodb.DynamoDBConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.source.extension.BaseGetConfigSourceConfigurationCommand;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import java.util.Map;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-dynamodb-config-source-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=MicroprofileConfigConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-dynamodb-config-source-configuration", description="List DynamoDB Config Source Configuration")})
public class GetDynamoDBConfigSourceConfigurationCommand
extends BaseGetConfigSourceConfigurationCommand<DynamoDBConfigSourceConfiguration> {
    protected Map<String, Object> getConfigSourceConfiguration(DynamoDBConfigSourceConfiguration configuration) {
        Map config = super.getConfigSourceConfiguration((ConfigSourceConfiguration)configuration);
        if (configuration != null) {
            config.put("Region Name", configuration.getRegionName());
            config.put("Table Name", configuration.getTableName());
            config.put("Key Column Name", configuration.getKeyColumnName());
            config.put("Value Column Name", configuration.getValueColumnName());
            config.put("Limit", configuration.getLimit());
        }
        return config;
    }
}

