/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.hashicorp;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fish.payara.microprofile.config.extensions.hashicorp.HashiCorpSecretsConfigSourceConfiguration;
import fish.payara.microprofile.config.extensions.hashicorp.model.SecretHolder;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonParser;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.config.support.TranslatedConfigView;
import org.jvnet.hk2.annotations.Service;

@Service(name="hashicorp-secrets-config-source")
public class HashiCorpSecretsConfigSource
extends ConfiguredExtensionConfigSource<HashiCorpSecretsConfigSourceConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(HashiCorpSecretsConfigSource.class.getName());
    private Client client = ClientBuilder.newClient();
    protected String hashiCorpVaultToken;
    protected String vaultAddress;
    protected String secretsEnginePath;
    protected String secretsPath;
    protected int apiVersion;
    private final ObjectMapper mapper = new ObjectMapper();

    public void bootstrap() {
        try {
            this.hashiCorpVaultToken = TranslatedConfigView.getRealPasswordFromAlias((String)"${ALIAS=HASHICORP_VAULT_TOKEN}");
            this.vaultAddress = this.removeForwardSlashFromSuffixAndPrefix(((HashiCorpSecretsConfigSourceConfiguration)this.configuration).getVaultAddress());
            this.secretsEnginePath = this.removeForwardSlashFromSuffixAndPrefix(((HashiCorpSecretsConfigSourceConfiguration)this.configuration).getSecretsEnginePath());
            this.secretsPath = this.removeForwardSlashFromSuffixAndPrefix(((HashiCorpSecretsConfigSourceConfiguration)this.configuration).getSecretsPath());
            this.apiVersion = Integer.parseInt(((HashiCorpSecretsConfigSourceConfiguration)this.configuration).getApiVersion());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOGGER.log(Level.WARNING, "Unable to get value from password aliases", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getProperties() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (this.hashiCorpVaultToken == null) {
            HashiCorpSecretsConfigSource.printMisconfigurationMessage();
            return results;
        }
        String secretsURL = this.vaultAddress + "/v1/" + this.secretsEnginePath + "/data/" + this.secretsPath;
        if (this.apiVersion == 1) {
            secretsURL = this.vaultAddress + "/v1/" + this.secretsEnginePath + "/" + this.secretsPath;
        }
        WebTarget secretsTarget = this.client.target(secretsURL);
        Response secretsResponse = secretsTarget.request().accept(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.hashiCorpVaultToken)).get();
        if (secretsResponse.getStatus() != 200) {
            LOGGER.log(Level.WARNING, "Unable to get secrets from the vault using the following URL: " + secretsURL + ". Make sure all the configurtaion options has been entered correctly and HashiCorp Vault Token is correct");
            return results;
        }
        try {
            String secretString = this.readSecretString((InputStream)secretsResponse.getEntity());
            try (StringReader reader = new StringReader(secretString);){
                Map<String, String> map = this.readMap(reader);
                return map;
            }
        }
        catch (IOException | JsonException | ProcessingException ex) {
            LOGGER.log(Level.WARNING, "Unable to read secret value", ex);
            return results;
        }
    }

    public String getValue(String propertyName) {
        if (this.hashiCorpVaultToken == null) {
            HashiCorpSecretsConfigSource.printMisconfigurationMessage();
            return null;
        }
        return this.getProperties().get(propertyName);
    }

    public boolean setValue(String secretName, String secretValue) {
        if (this.hashiCorpVaultToken == null) {
            HashiCorpSecretsConfigSource.printMisconfigurationMessage();
            return false;
        }
        Map<String, String> properties = this.getProperties();
        properties.put(secretName, secretValue);
        return this.modifySecret(properties);
    }

    private boolean modifySecret(Map<String, String> properties) {
        Object payload;
        String secretsURL = this.vaultAddress + "/v1/" + this.secretsEnginePath + "/data/" + this.secretsPath;
        if (this.apiVersion == 1) {
            secretsURL = this.vaultAddress + "/v1/" + this.secretsEnginePath + "/" + this.secretsPath;
        }
        WebTarget target = this.client.target(secretsURL);
        if (this.apiVersion == 1) {
            Map<String, String> secrets = properties;
            payload = Json.createObjectBuilder(secrets).build().toString();
        } else {
            payload = new SecretHolder(properties);
        }
        Response setSecretResponse = target.request().accept(new String[]{"application/json"}).header("Content-Type", (Object)"application/json").header("Authorization", (Object)("Bearer " + this.hashiCorpVaultToken)).put(Entity.entity((Object)payload, (String)"application/json"));
        if (setSecretResponse.getStatus() == 200) {
            return true;
        }
        LOGGER.log(Level.WARNING, "Failed to modify HashiCorp secret. {0}", setSecretResponse.readEntity(String.class));
        return false;
    }

    public boolean deleteValue(String secretName) {
        if (this.hashiCorpVaultToken == null) {
            HashiCorpSecretsConfigSource.printMisconfigurationMessage();
            return false;
        }
        Map<String, String> properties = this.getProperties();
        properties.remove(secretName);
        return this.modifySecret(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readSecretString(InputStream input) {
        try (JsonParser parser = Json.createParser((InputStream)input);){
            String keyName;
            block21: {
                while (parser.hasNext()) {
                    JsonParser.Event parseEvent = parser.next();
                    if (parseEvent != JsonParser.Event.KEY_NAME) continue;
                    keyName = parser.getString();
                    parser.next();
                    if (!"data".equals(keyName)) {
                        continue;
                    }
                    break block21;
                }
                return null;
            }
            if (this.apiVersion == 1) {
                String string = parser.getObject().toString();
                return string;
            }
            String string = parser.getObject().getJsonObject(keyName).toString();
            return string;
        }
    }

    private Map<String, String> readMap(Reader input) throws JsonParseException, JsonMappingException, IOException {
        return (Map)this.mapper.readValue(input, (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public String getSource() {
        return "cloud";
    }

    public String getName() {
        return "hashicorp";
    }

    private static void printMisconfigurationMessage() {
        LOGGER.warning("HashiCorp Secrets Config Source isn't configured correctly. Make sure that the password aliases HASHICORP_VAULT_TOKEN exist.");
    }

    private String removeForwardSlashFromSuffixAndPrefix(String path) {
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }
}

