/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.extensions.ldap;

import com.sun.enterprise.util.StringUtils;
import fish.payara.microprofile.config.extensions.ldap.LDAPConfigSourceConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.glassfish.config.support.TranslatedConfigView;

public class LDAPConfigSourceHelper {
    private static final Logger logger = Logger.getLogger(LDAPConfigSourceHelper.class.getName());
    private final LDAPConfigSourceConfiguration configuration;

    public LDAPConfigSourceHelper(LDAPConfigSourceConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getConfigValue(String propertyName) {
        String propertyValue = null;
        StartTlsResponse tlsResponse = null;
        LdapContext context = this.getContext();
        if (Boolean.valueOf(this.configuration.getStartTLSEnabled()).booleanValue()) {
            tlsResponse = this.startTLSConnection(context);
        }
        try {
            if (context != null) {
                if (StringUtils.ok((String)this.configuration.getSearchBase()) && StringUtils.ok((String)this.configuration.getSearchFilter())) {
                    SearchControls controls = new SearchControls();
                    controls.setReturningAttributes(new String[]{propertyName});
                    controls.setSearchScope(LDAPConfigSourceHelper.convertScopeValue(this.configuration.getSearchBase()));
                    NamingEnumeration<SearchResult> searchResults = context.search(this.configuration.getSearchBase(), this.configuration.getSearchFilter(), controls);
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (searchResults.hasMoreElements()) {
                        SearchResult searchResult = searchResults.next();
                        Attributes attributes = searchResult.getAttributes();
                        Attribute attribute = attributes.get(propertyName);
                        if (attribute == null) continue;
                        if (attribute.size() > 1) {
                            results.addAll(Collections.list(attribute.getAll()));
                            continue;
                        }
                        results.add(attribute.get());
                    }
                    if (!results.isEmpty()) {
                        propertyValue = results.stream().map(e -> String.valueOf(e)).collect(Collectors.joining(","));
                    }
                } else {
                    Attributes attributes = context.getAttributes(this.configuration.getBindDN());
                    Attribute attribute = attributes.get(propertyName);
                    if (attribute != null) {
                        propertyValue = attribute.size() > 1 ? Collections.list(attribute.getAll()).stream().map(e -> String.valueOf(e)).collect(Collectors.joining(",")) : attribute.get().toString();
                    }
                }
            }
        }
        catch (NamingException ex) {
            logger.log(Level.WARNING, "Could not find the LDAP attibute named {0}:{1}", new Object[]{propertyName, ex.getMessage()});
        }
        finally {
            LDAPConfigSourceHelper.closeConnection(context, tlsResponse);
        }
        return propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, String> getAllConfigValues() {
        Map<String, String> configValues = new HashMap<String, String>();
        StartTlsResponse tlsResponse = null;
        LdapContext context = this.getContext();
        if (Boolean.valueOf(this.configuration.getStartTLSEnabled()).booleanValue()) {
            tlsResponse = this.startTLSConnection(context);
        }
        try {
            if (context != null) {
                if (StringUtils.ok((String)this.configuration.getSearchBase()) && StringUtils.ok((String)this.configuration.getSearchFilter())) {
                    SearchControls controls = new SearchControls();
                    controls.setReturningAttributes(null);
                    controls.setSearchScope(LDAPConfigSourceHelper.convertScopeValue(this.configuration.getSearchBase()));
                    NamingEnumeration<SearchResult> searchResults = context.search(this.configuration.getSearchBase(), this.configuration.getSearchFilter(), controls);
                    HashMap<String, ArrayList<Object>> results = new HashMap<String, ArrayList<Object>>();
                    while (searchResults.hasMoreElements()) {
                        SearchResult searchResult = searchResults.next();
                        Attributes attributes = searchResult.getAttributes();
                        NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
                        while (attributeEnumeration.hasMoreElements()) {
                            Attribute attribute = (Attribute)attributeEnumeration.nextElement();
                            ArrayList<Object> values = (ArrayList<Object>)results.get(attribute.getID());
                            if (values == null) {
                                values = new ArrayList<Object>();
                                results.put(attribute.getID(), values);
                            }
                            values.add(attribute.get());
                        }
                    }
                    configValues = results.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(String::valueOf).collect(Collectors.joining(","))));
                } else {
                    Attributes attributes = context.getAttributes(this.configuration.getBindDN());
                    NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
                    while (attributeEnumeration.hasMoreElements()) {
                        Attribute attribute = (Attribute)attributeEnumeration.nextElement();
                        configValues.put(attribute.getID(), attribute.get().toString());
                    }
                }
            }
        }
        catch (NamingException ex) {
            logger.log(Level.WARNING, "Could not fetch the LDAP attibutes:{0}", ex.getMessage());
        }
        finally {
            LDAPConfigSourceHelper.closeConnection(context, tlsResponse);
        }
        return configValues;
    }

    private LdapContext getContext() {
        LdapContext context = null;
        if (StringUtils.ok((String)this.configuration.getUrl())) {
            try {
                context = this.getContext(this.configuration.getUrl(), this.configuration.getBindDN(), this.configuration.getBindDNPassword(), Boolean.valueOf(this.configuration.getStartTLSEnabled()), this.configuration.getConnectionTimeout(), this.configuration.getReadTimeout());
            }
            catch (NamingException ex) {
                logger.log(Level.SEVERE, "Could not create the LDAP context for {0}:{1}", new Object[]{this.configuration.getUrl(), ex.getMessage()});
            }
        }
        return context;
    }

    private StartTlsResponse startTLSConnection(LdapContext context) {
        StartTlsResponse tlsResponse = null;
        if (Boolean.valueOf(this.configuration.getStartTLSEnabled()).booleanValue()) {
            try {
                tlsResponse = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
                if (tlsResponse == null) {
                    throw new NamingException("Could not establish the LDAP connection through StartTLS");
                }
                try {
                    tlsResponse.negotiate();
                }
                catch (IOException ex) {
                    throw new AuthenticationException("Could not negotiate TLS");
                }
                context.addToEnvironment("java.naming.security.authentication", this.configuration.getAuthType());
                if (!"none".equals(this.configuration.getAuthType())) {
                    context.addToEnvironment("java.naming.security.principal", this.configuration.getBindDN());
                    context.addToEnvironment("java.naming.security.credentials", this.translatePassword(this.configuration.getBindDNPassword()));
                }
                context.lookup("");
            }
            catch (NamingException ex) {
                logger.log(Level.SEVERE, "Could not create the LDAP context for '{0}':{1}", new Object[]{this.configuration.getUrl(), ex.getMessage()});
            }
        }
        return tlsResponse;
    }

    private LdapContext getContext(String url, String bindDN, String bindDNPassword, boolean startTLS, String connectionTimeout, String readTimeout) throws NamingException {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", url);
        if (!startTLS) {
            environment.put("java.naming.security.authentication", this.configuration.getAuthType());
            if (!"none".equals(this.configuration.getAuthType())) {
                environment.put("java.naming.security.principal", bindDN);
                environment.put("java.naming.security.credentials", this.translatePassword(bindDNPassword));
            }
        }
        if (StringUtils.ok((String)connectionTimeout)) {
            environment.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
        }
        if (StringUtils.ok((String)readTimeout)) {
            environment.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        }
        return new InitialLdapContext(environment, null);
    }

    private char[] translatePassword(String bindDNPassword) {
        if (bindDNPassword != null && TranslatedConfigView.getAlias((String)bindDNPassword) != null) {
            try {
                bindDNPassword = TranslatedConfigView.getRealPasswordFromAlias((String)bindDNPassword);
            }
            catch (Exception iae) {
                logger.log(Level.WARNING, iae.getMessage(), iae);
            }
        }
        return bindDNPassword != null ? bindDNPassword.toCharArray() : null;
    }

    private static void closeConnection(LdapContext context, StartTlsResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (context != null) {
                context.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private static int convertScopeValue(String searchScope) {
        if ("onelevel".equals(searchScope)) {
            return 1;
        }
        if ("subtree".equals(searchScope)) {
            return 2;
        }
        if ("object".equals(searchScope)) {
            return 0;
        }
        return 1;
    }
}

