/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.boot.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;

public class BootCommand {
    private final String command;
    private final String[] arguments;
    private static final Logger LOGGER = Logger.getLogger(BootCommand.class.getName());

    public BootCommand(String command, String ... arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    public boolean execute(CommandRunner runner) {
        boolean result = true;
        CommandResult asadminResult = runner.run(this.command, this.arguments);
        if (asadminResult.getExitStatus().equals((Object)CommandResult.ExitStatus.FAILURE)) {
            LOGGER.log(Level.WARNING, String.format("Boot Command %s failed %s ", this.command, asadminResult.getOutput()), asadminResult.getFailureCause());
            result = false;
        } else {
            LOGGER.log(Level.INFO, String.format("Boot Command %s returned with result %s : %s", new Object[]{this.command, asadminResult.getExitStatus(), asadminResult.getOutput()}));
        }
        return result;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }
}

