/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.healthcheck.microprofile.metrics;

import fish.payara.healthcheck.microprofile.metrics.HealthCheckMicroProfileMetricstExecutionOptions;
import fish.payara.healthcheck.microprofile.metrics.StringWriterProxy;
import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.writer.FilteredMetricsExporter;
import fish.payara.microprofile.metrics.writer.MetricExporter;
import fish.payara.microprofile.metrics.writer.MetricsWriter;
import fish.payara.microprofile.metrics.writer.MetricsWriterImpl;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.configuration.MicroProfileMetricsChecker;
import fish.payara.nucleus.healthcheck.configuration.MonitoredMetric;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-mpmetrics")
@RunLevel(value=10)
public class MicroProfileMetricsCheck
extends BaseHealthCheck<HealthCheckMicroProfileMetricstExecutionOptions, MicroProfileMetricsChecker> {
    @Inject
    private MetricsService metricsService;
    private StringWriterProxy buffer;
    private MetricsWriter writer;

    @PostConstruct
    public void postConstruct() {
        this.postConstruct(this, MicroProfileMetricsChecker.class);
    }

    @Override
    public synchronized HealthCheckMicroProfileMetricstExecutionOptions constructOptions(MicroProfileMetricsChecker checker) {
        HashSet<String> metricNames = new HashSet<String>();
        for (MonitoredMetric metric : checker.getMonitoredMetrics()) {
            metricNames.add(metric.getMetricName());
        }
        this.buffer = new StringWriterProxy();
        this.writer = new MetricsWriterImpl((MetricExporter)new FilteredMetricsExporter((Writer)this.buffer, metricNames), () -> ((MetricsService)this.metricsService).getAllRegistryNames(), arg_0 -> ((MetricsService)this.metricsService).getRegistry(arg_0));
        return new HealthCheckMicroProfileMetricstExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()), checker.getMonitoredMetrics());
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.MPmetrics";
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        List<MonitoredMetric> monitoredMetrics = ((HealthCheckMicroProfileMetricstExecutionOptions)this.options).getMonitoredMetrics();
        HealthCheckResult result = new HealthCheckResult();
        try {
            if (monitoredMetrics != null && !monitoredMetrics.isEmpty()) {
                String data = this.write();
                result.add(new HealthCheckResultEntry(data.isEmpty() ? HealthCheckResultStatus.WARNING : HealthCheckResultStatus.GOOD, data.isEmpty() ? "The metrics you have added for monitoring doesn't exist" : data));
            } else {
                result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, "No metric has been added for monitoring."));
            }
        }
        catch (IOException ex) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, "Failed to write metrics to stream."));
        }
        return result;
    }

    private synchronized String write() throws IOException {
        this.writer.write();
        String result = this.buffer.toString().trim().replaceAll(",$", "");
        this.buffer.clear();
        return result;
    }
}

