/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.config.cdi;

import fish.payara.microprofile.config.cdi.ConfigProducer;
import fish.payara.microprofile.config.cdi.ConfigPropertyProducer;
import fish.payara.microprofile.config.cdi.TypesBeanAttributes;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfig;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigCdiExtension
implements Extension {
    public void validateInjectionPoint(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty property = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (property != null) {
            try {
                Class rawClazz;
                Type t = pip.getInjectionPoint().getType();
                if (Class.class.isInstance(pip.getInjectionPoint().getType())) {
                    ConfigPropertyProducer.getGenericProperty(pip.getInjectionPoint());
                } else if (t instanceof ParameterizedType && (rawClazz = (Class)((ParameterizedType)t).getRawType()) != Provider.class && rawClazz != Optional.class) {
                    ConfigPropertyProducer.getGenericProperty(pip.getInjectionPoint());
                }
            }
            catch (Throwable de) {
                Class failingClass = null;
                Bean bean = pip.getInjectionPoint().getBean();
                failingClass = bean == null ? pip.getInjectionPoint().getMember().getDeclaringClass() : pip.getInjectionPoint().getBean().getBeanClass();
                pip.addDefinitionError((Throwable)new DeploymentException("Deployment Failure for ConfigProperty " + property.name() + " in class " + failingClass.getCanonicalName() + " Reason " + de.getMessage(), de));
            }
        }
    }

    public void createConfigProducer(@Observes BeforeBeanDiscovery event, BeanManager bm) {
        AnnotatedType at = bm.createAnnotatedType(ConfigProducer.class);
        event.addAnnotatedType(at, ConfigProducer.class.getName());
    }

    public void addDynamicProducers(@Observes AfterBeanDiscovery event, BeanManager bm) {
        Config config = ConfigProvider.getConfig();
        if (config instanceof PayaraConfig) {
            AnnotatedType atype = bm.createAnnotatedType(ConfigPropertyProducer.class);
            BeanAttributes beanAttr = null;
            AnnotatedMethod method = null;
            for (AnnotatedMethod m : atype.getMethods()) {
                if (!m.getJavaMember().getName().equals("getGenericProperty")) continue;
                beanAttr = bm.createBeanAttributes((AnnotatedMember)m);
                method = m;
                break;
            }
            if (beanAttr != null) {
                HashSet<Class<String>> types = new HashSet<Class<String>>();
                types.addAll(((PayaraConfig)config).getConverterTypes());
                types.add(String.class);
                for (final Type type : types) {
                    Bean bean = bm.createBean((BeanAttributes)new TypesBeanAttributes<Object>(beanAttr){

                        public Set<Type> getTypes() {
                            HashSet<Type> result = new HashSet<Type>();
                            result.add(type);
                            if (type instanceof Class) {
                                Object array = Array.newInstance((Class)type, 0);
                                result.add(array.getClass());
                            }
                            if (type == Long.class) {
                                result.add(Long.TYPE);
                                result.add(new long[0].getClass());
                            } else if (type == Boolean.class) {
                                result.add(Boolean.TYPE);
                                result.add(new boolean[0].getClass());
                            } else if (type == Integer.class) {
                                result.add(Integer.TYPE);
                                result.add(new int[0].getClass());
                            } else if (type == Float.class) {
                                result.add(Float.TYPE);
                                result.add(new float[0].getClass());
                            } else if (type == Double.class) {
                                result.add(Double.TYPE);
                                result.add(new double[0].getClass());
                            }
                            return result;
                        }
                    }, ConfigPropertyProducer.class, bm.getProducerFactory(method, null));
                    event.addBean(bean);
                }
            }
        }
    }
}

