/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.internal.notification;

import com.sun.enterprise.config.serverbeans.Server;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotificationBuilder;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class PayaraNotificationFactory {
    private static final Logger LOGGER = Logger.getLogger(PayaraNotificationFactory.class.getName());
    @Inject
    private ServerEnvironment environment;
    @Inject
    private ServiceLocator habitat;

    public PayaraNotification buildNotificationEvent(String subject, String message) {
        return this.newBuilder().subject(subject).message(message).build();
    }

    public PayaraNotification buildNotificationEvent(Level level, String subject, String message, Object[] parameters) {
        if (parameters != null && parameters.length > 0) {
            message = MessageFormat.format(message, parameters);
        }
        return this.newBuilder().subject(subject).message(message).eventType(level.getName()).build();
    }

    public PayaraNotificationBuilder newBuilder() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOGGER.log(Level.WARNING, "Unable to resolve local hostname", ex);
            hostName = "?.?.?.?";
        }
        String domainName = this.environment.getDomainName();
        String instanceName = this.environment.getInstanceName();
        Server server = (Server)this.habitat.getService(Server.class, this.environment.getInstanceName(), new Annotation[0]);
        String serverName = server.getName();
        return new PayaraNotificationBuilder(hostName, domainName, instanceName, serverName);
    }
}

