/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hotdeploy;

import fish.payara.nucleus.hotdeploy.AnnotationProcessorState;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.ResourceClassLoader;
import org.glassfish.api.deployment.ResourceEntry;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;

public class ApplicationState {
    private final File path;
    private final String name;
    private String target;
    private Set<String> sniffers;
    private List<EngineInfo> engineInfos = Collections.emptyList();
    private ModuleInfo moduleInfo;
    private ApplicationInfo applicationInfo;
    private ExtendedDeploymentContext deploymentContext;
    private ClassLoader applicationClassLoader;
    private Map<String, Object> descriptorMetadata = Collections.emptyMap();
    private Map<String, Object> modulesMetaData = Collections.emptyMap();
    private Set<String> classesChanged = Collections.emptySet();
    private final Map<String, AnnotationProcessorState> processingStates = new HashMap<String, AnnotationProcessorState>();
    private boolean active;
    private Set<ClassLoader> previousClassLoaders;
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private static final String CLASS_EXT = ".class";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";

    public ApplicationState(String name, File path, ExtendedDeploymentContext deploymentContext) {
        this.name = name;
        this.path = path;
        this.deploymentContext = deploymentContext;
    }

    public File getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public ExtendedDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public Map<String, Object> getDescriptorMetadata() {
        return this.descriptorMetadata;
    }

    public List<EngineInfo> getEngineInfos() {
        return this.engineInfos;
    }

    public void setEngineInfos(List<EngineInfo> engineInfos) {
        this.engineInfos = engineInfos;
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public void setModuleInfo(ModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public Set<String> getSniffers() {
        return this.sniffers;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInactive() {
        return !this.active;
    }

    public void setSniffers(Collection<? extends Sniffer> sniffers) {
        Set snifferTypes = sniffers.stream().map(s -> (Sniffer)Sniffer.class.cast(s)).map(Sniffer::getModuleType).collect(Collectors.toSet());
        if (!snifferTypes.equals(this.sniffers)) {
            this.sniffers = snifferTypes;
            this.moduleInfo = null;
            this.engineInfos = null;
        }
    }

    public void start(ExtendedDeploymentContext newContext, Events events) {
        this.validateInactiveState();
        this.active = true;
        if (this.applicationInfo != null) {
            this.previousClassLoaders = this.getClassLoaders(this.applicationInfo);
        }
        newContext.getAppProps().putAll((Map<?, ?>)this.deploymentContext.getAppProps());
        newContext.getModulePropsMap().putAll(this.deploymentContext.getModulePropsMap());
        Set<Class> requiredMetaDataClasses = this.requiredMetaDataClasses();
        this.modulesMetaData.values().stream().filter(md -> !requiredMetaDataClasses.contains(md.getClass())).forEach(arg_0 -> ((ExtendedDeploymentContext)newContext).addModuleMetaData(arg_0));
        this.getDescriptorMetadata().entrySet().forEach(e -> newContext.addTransientAppMetaData((String)e.getKey(), e.getValue()));
        this.deploymentContext = newContext;
        DeployCommandParameters commandParams = (DeployCommandParameters)newContext.getCommandParameters(DeployCommandParameters.class);
        if (commandParams.sourcesChanged != null) {
            this.classesChanged = new HashSet<String>();
            for (String sourcePath : commandParams.sourcesChanged) {
                String className = this.getClassName(sourcePath);
                if (className == null) continue;
                this.classesChanged.add(className);
            }
        }
        if (this.applicationClassLoader != null && this.applicationClassLoader instanceof ResourceClassLoader) {
            ClassLoader newClassLoader = newContext.getArchiveHandler().getClassLoader(this.applicationClassLoader.getParent(), (DeploymentContext)newContext);
            ResourceClassLoader newResourceClassLoader = (ResourceClassLoader)ResourceClassLoader.class.cast(newClassLoader);
            ResourceClassLoader previousResourceClassLoader = (ResourceClassLoader)ResourceClassLoader.class.cast(this.applicationClassLoader);
            ConcurrentHashMap previousResourceEntries = previousResourceClassLoader.getResourceEntries();
            previousResourceEntries.entrySet().stream().filter(e -> !this.classesChanged.contains(e.getKey())).forEach(e -> newResourceClassLoader.addResourceEntry((String)e.getKey(), (ResourceEntry)e.getValue()));
            newContext.setClassLoader(newClassLoader);
        }
        if (this.applicationInfo != null) {
            events.send(new EventListener.Event(Deployment.APPLICATION_UNLOADED, (Object)this.applicationInfo), false);
        }
    }

    public void setApplicationClassLoader(ClassLoader applicationClassLoader) {
        this.applicationClassLoader = applicationClassLoader;
    }

    public void addProcessingContext(Class descriptor, Object processingContext) {
        this.processingStates.put(descriptor.getName(), new AnnotationProcessorState(processingContext));
    }

    public <P> P getProcessingContext(Class descriptor, Class<P> _class) {
        AnnotationProcessorState processorState = this.processingStates.get(descriptor.getName());
        if (processorState != null) {
            return processorState.getProcessingContext(_class);
        }
        return null;
    }

    public Optional<AnnotationProcessorState> getProcessingState(Object processingContext) {
        for (Map.Entry<String, AnnotationProcessorState> entry : this.processingStates.entrySet()) {
            if (!entry.getValue().getProcessingContext().equals(processingContext)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public boolean isClassChanged(Class clazz) {
        this.validateActiveState();
        return this.classesChanged.contains(clazz.getName());
    }

    public Set<String> getClassesChanged() {
        return this.classesChanged;
    }

    public void storeMetaData(ExtendedDeploymentContext deploymentContext) {
        this.modulesMetaData = deploymentContext.getModuleMetadata().stream().collect(Collectors.toMap(metaData -> metaData.getClass().getName(), Function.identity()));
        this.descriptorMetadata = deploymentContext.getTransientAppMetadata().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(WEB_INF) || ((String)e.getKey()).startsWith(META_INF)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        for (Object metadata : this.modulesMetaData.values()) {
            try {
                return metadataType.cast(metadata);
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    public void close() {
        this.active = false;
        this.classesChanged.clear();
        if (this.previousClassLoaders != null) {
            for (ClassLoader cloader : this.previousClassLoaders) {
                try {
                    ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
                }
                catch (Exception exception) {}
            }
            this.previousClassLoaders.clear();
        }
    }

    public void preDestroy() {
        try {
            ((PreDestroy)PreDestroy.class.cast(this.applicationClassLoader)).preDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applicationClassLoader = null;
    }

    private void validateActiveState() {
        if (!this.active) {
            throw new IllegalStateException(String.format("Application [%s] state must be active.", this.name));
        }
    }

    private void validateInactiveState() {
        if (this.active) {
            throw new IllegalStateException(String.format("Application [%s] state must not be active.", this.name));
        }
    }

    private String getClassName(String sourcePath) {
        String className = null;
        if (sourcePath.endsWith(CLASS_EXT)) {
            int startIndex = 0;
            int endIndex = sourcePath.length() - CLASS_EXT.length();
            if (sourcePath.startsWith(WEB_INF_CLASSES)) {
                startIndex = WEB_INF_CLASSES.length() + 1;
            }
            className = sourcePath.substring(startIndex, endIndex).replace('\\', '.').replace('/', '.');
        }
        return className;
    }

    private Set<ClassLoader> getClassLoaders(ApplicationInfo appInfo) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>(appInfo.getClassLoaders());
        classLoaders.add(appInfo.getModuleClassLoader());
        classLoaders.add(appInfo.getAppClassLoader());
        for (ModuleInfo module : appInfo.getModuleInfos()) {
            classLoaders.addAll(module.getClassLoaders());
            classLoaders.add(module.getModuleClassLoader());
        }
        return classLoaders;
    }

    private Set<Class> requiredMetaDataClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        if (this.engineInfos != null) {
            for (EngineInfo engineInfo : this.engineInfos) {
                if (engineInfo.getDeployer() == null) continue;
                classes.addAll(Arrays.asList(engineInfo.getDeployer().getMetaData().requires()));
            }
        }
        return classes;
    }
}

