/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment.analysis;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.analysis.DeploymentSpan;
import org.glassfish.internal.deployment.analysis.SpanSequence;
import org.glassfish.internal.deployment.analysis.TraceContext;

public final class StructuredDeploymentTracing
implements AutoCloseable {
    private final Clock clock;
    private final TraceContext rootContext;
    private TraceContext currentContext;
    private DeploymentSpan currentSpan;
    private List<DeploymentSpan> spans = new ArrayList<DeploymentSpan>();
    private boolean disabled;
    private DeploymentSpan disabledSpan;

    public static StructuredDeploymentTracing create(String appName) {
        return new StructuredDeploymentTracing(appName);
    }

    public static StructuredDeploymentTracing createDisabled(String appName) {
        return new StructuredDeploymentTracing(appName).disable();
    }

    private StructuredDeploymentTracing(String appName) {
        this(Clock.systemDefaultZone(), appName);
    }

    StructuredDeploymentTracing(Clock clock, String appName) {
        this.clock = clock;
        this.rootContext = this.pushContext(TraceContext.Level.APPLICATION, appName);
        this.startRootSpan(appName);
    }

    public static StructuredDeploymentTracing load(DeploymentContext context) {
        if (context == null) {
            return StructuredDeploymentTracing.createDisabled("temp");
        }
        StructuredDeploymentTracing instance = (StructuredDeploymentTracing)context.getModuleMetaData(StructuredDeploymentTracing.class);
        if (instance == null) {
            return StructuredDeploymentTracing.createDisabled("temp");
        }
        return instance;
    }

    public DeploymentSpan startSpan(Enum<?> action) {
        return this.startSpan(action, null);
    }

    public DeploymentSpan startSpan(Enum<?> action, String componentName) {
        if (this.disabled) {
            return this.disabledSpan;
        }
        this.currentSpan = DeploymentSpan.createOpen(this.clock, this.currentContext, componentName, action);
        this.spans.add(this.currentSpan);
        return this.currentSpan;
    }

    public DeploymentSpan startSpan(TraceContext.Level level, String contextName, Enum<?> action) {
        return this.startSpan(level, contextName, action, null);
    }

    public DeploymentSpan startSpan(TraceContext.Level level, String contextName, Enum<?> action, String componentName) {
        this.switchToContext(level, contextName);
        return this.startSpan(action, componentName);
    }

    public SpanSequence startSequence(Enum<?> action) {
        return this.startSequence(action, null);
    }

    public SpanSequence startSequence(Enum<?> action, String componentName) {
        return new SpanSequence(this, this.startSpan(action, componentName));
    }

    public TraceContext switchToContext(TraceContext.Level level, String name) {
        if (this.disabled) {
            return this.rootContext;
        }
        if (this.popUpTo(level) != null) {
            if (level != TraceContext.Level.APPLICATION && !name.equals(this.currentContext.getName())) {
                this.popContext();
            } else {
                return this.currentContext;
            }
        }
        return this.pushContext(level, name);
    }

    public void addModuleMark(String moduleName, DeploymentTracing.ModuleMark mark) {
        this.switchToContext(TraceContext.Level.MODULE, moduleName);
        this.appendSpan(mark, null);
    }

    @Override
    public void close() {
        while (this.currentContext != null) {
            this.popContext();
        }
        this.postProcess();
    }

    private void postProcess() {
        ArrayDeque<Instant> levelEnds = new ArrayDeque<Instant>();
        for (DeploymentSpan span : this.spans) {
            Iterator ends = levelEnds.descendingIterator();
            while (ends.hasNext()) {
                Instant end = (Instant)ends.next();
                if (span.getStart().isBefore(end)) break;
                ends.remove();
            }
            levelEnds.add(span.getFinish());
            span.setNestLevel(levelEnds.size());
        }
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public DeploymentTracing register(DeploymentContext deploymentContext) {
        deploymentContext.addModuleMetaData((Object)this);
        if (this.isEnabled()) {
            DeploymentTracing legacyTracing = new DeploymentTracing(this);
            deploymentContext.addModuleMetaData((Object)legacyTracing);
            return legacyTracing;
        }
        return null;
    }

    public void print(PrintWriter out) {
        this.close();
        this.spans.forEach(span -> out.println(span));
    }

    public void print(PrintStream out) {
        StringWriter stringOut = new StringWriter();
        this.print(new PrintWriter(stringOut));
        out.println(stringOut.toString());
    }

    public void addApplicationMark(DeploymentTracing.Mark mark) {
        this.popUpTo(TraceContext.Level.APPLICATION);
        this.appendSpan(mark, null);
    }

    public void addContainerMark(String name, DeploymentTracing.ContainerMark mark) {
        this.switchToContext(TraceContext.Level.CONTAINER, name);
        this.appendSpan(mark, null);
    }

    private DeploymentSpan startRootSpan(String appName) {
        return this.startSpan(null, null);
    }

    private StructuredDeploymentTracing disable() {
        this.disabled = true;
        this.disabledSpan = DeploymentSpan.createOpen(this.clock, this.rootContext, "dummy", null);
        return this;
    }

    private DeploymentSpan appendSpan(Enum<?> action, String componentName) {
        if (this.disabled) {
            return this.disabledSpan;
        }
        this.currentSpan = DeploymentSpan.createClosed(this.currentSpan, this.clock, this.currentContext, componentName, action);
        this.spans.add(this.currentSpan);
        return this.currentSpan;
    }

    private TraceContext pushContext(TraceContext.Level level, String contextName) {
        this.currentContext = new TraceContext(this.currentContext, level, contextName, this.clock);
        return this.currentContext;
    }

    private TraceContext popContext() {
        if (this.currentContext != null) {
            TraceContext head = this.currentContext;
            this.currentContext = head.pop();
            return head;
        }
        return null;
    }

    private TraceContext popUpTo(TraceContext.Level level) {
        if (this.currentContext == null || !this.currentContext.isWithin(level)) {
            return null;
        }
        while (!this.currentContext.is(level)) {
            this.popContext();
        }
        return this.currentContext;
    }
}

