/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.lang.annotation.Annotation;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.model.internal.ManagedObjectsFinalizer;
import org.glassfish.jersey.process.internal.AbstractExecutorProvidersConfigurator;
import org.glassfish.jersey.server.BackgroundScheduler;
import org.glassfish.jersey.server.BackgroundSchedulerLiteral;
import org.glassfish.jersey.server.ManagedAsyncExecutor;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBootstrapBag;
import org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;
import org.glassfish.jersey.spi.ScheduledThreadPoolExecutorProvider;
import org.glassfish.jersey.spi.ThreadPoolExecutorProvider;

class ServerExecutorProvidersConfigurator
extends AbstractExecutorProvidersConfigurator {
    ServerExecutorProvidersConfigurator() {
    }

    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        ComponentBag componentBag = runtimeConfig.getComponentBag();
        ManagedObjectsFinalizer finalizer = serverBag.getManagedObjectsFinalizer();
        DefaultBackgroundSchedulerProvider defaultScheduledExecutorProvider = new DefaultBackgroundSchedulerProvider();
        InstanceBinding schedulerBinding = (InstanceBinding)((InstanceBinding)Bindings.service((Object)((Object)defaultScheduledExecutorProvider)).to(ScheduledExecutorServiceProvider.class)).qualifiedBy((Annotation)BackgroundSchedulerLiteral.INSTANCE);
        injectionManager.register((Binding)schedulerBinding);
        finalizer.registerForPreDestroyCall((Object)defaultScheduledExecutorProvider);
        DefaultManagedAsyncExecutorProvider defaultAsyncExecutorProvider = new DefaultManagedAsyncExecutorProvider();
        InstanceBinding executorBinding = (InstanceBinding)Bindings.service((Object)((Object)defaultAsyncExecutorProvider)).to(ExecutorServiceProvider.class);
        injectionManager.register((Binding)executorBinding);
        finalizer.registerForPreDestroyCall((Object)defaultAsyncExecutorProvider);
        this.registerExecutors(injectionManager, componentBag, (ExecutorServiceProvider)defaultAsyncExecutorProvider, (ScheduledExecutorServiceProvider)defaultScheduledExecutorProvider);
    }

    @ManagedAsyncExecutor
    private static class DefaultManagedAsyncExecutorProvider
    extends ThreadPoolExecutorProvider {
        public DefaultManagedAsyncExecutorProvider() {
            super("jersey-server-managed-async-executor");
        }
    }

    @BackgroundScheduler
    private static class DefaultBackgroundSchedulerProvider
    extends ScheduledThreadPoolExecutorProvider {
        public DefaultBackgroundSchedulerProvider() {
            super("jersey-background-task-scheduler");
        }

        protected int getCorePoolSize() {
            return 1;
        }
    }
}

