/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.nucleus.requesttracing.store.IterableThreadLocal;
import java.util.Map;
import java.util.UUID;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RequestTraceSpanStore {
    private IterableThreadLocal<RequestTrace> spanStore = new IterableThreadLocal<RequestTrace>(RequestTrace::new);

    public Iterable<Map.Entry<Thread, RequestTrace>> getTraces() {
        return this.spanStore;
    }

    void storeEvent(RequestTraceSpan payaraSpan) {
        RequestTrace currentTrace = (RequestTrace)this.spanStore.get();
        currentTrace.addEvent(payaraSpan);
    }

    void storeEvent(RequestTraceSpan payaraSpan, long timestampMillis) {
        RequestTrace currentTrace = (RequestTrace)this.spanStore.get();
        currentTrace.addEvent(payaraSpan, timestampMillis);
    }

    void endTrace() {
        RequestTrace currentTrace = (RequestTrace)this.spanStore.get();
        currentTrace.endTrace();
    }

    void endTrace(long timestampMillis) {
        RequestTrace currentTrace = (RequestTrace)this.spanStore.get();
        currentTrace.endTrace(timestampMillis);
    }

    long getElapsedTime() {
        return ((RequestTrace)this.spanStore.get()).getElapsedTime();
    }

    void flushStore() {
        this.spanStore.set(new RequestTrace());
    }

    String getTraceAsString() {
        return ((RequestTrace)this.spanStore.get()).toString();
    }

    public RequestTrace getTrace() {
        return (RequestTrace)this.spanStore.get();
    }

    UUID getTraceID() {
        RequestTrace trace = (RequestTrace)this.spanStore.get();
        return trace.getTraceId();
    }

    void setTraceId(UUID newID) {
        RequestTrace trace = (RequestTrace)this.spanStore.get();
        trace.setTraceId(newID);
    }

    boolean isTraceInProgress() {
        return ((RequestTrace)this.spanStore.get()).isStarted() && !((RequestTrace)this.spanStore.get()).isCompleted();
    }
}

