/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm.mechanisms;

import fish.payara.security.realm.CertificateCredentialImpl;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LogFacade;
import org.glassfish.soteria.Utils;

@Typed(value={CertificateAuthenticationMechanism.class})
public class CertificateAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    private IdentityStoreHandler identityStoreHandler;
    private static final Logger LOGGER = Logger.getLogger(CertificateAuthenticationMechanism.class.getName());
    protected static final ResourceBundle SERVLET_CONTAINER_BUNDLE = LogFacade.getLogger().getResourceBundle();

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMsgContext) throws AuthenticationException {
        CredentialValidationResult result;
        Object[] certificates = this.getCertificates(request);
        if (!Utils.isEmpty((Object[])certificates) && certificates.length != 0 && (result = this.identityStoreHandler.validate((Credential)new CertificateCredentialImpl((X509Certificate[])certificates))).getStatus() == CredentialValidationResult.Status.VALID) {
            return httpMsgContext.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), result.getCallerGroups());
        }
        if (httpMsgContext.isProtected()) {
            if (Utils.isEmpty((Object[])certificates) || certificates.length == 0) {
                try {
                    response.sendError(400, SERVLET_CONTAINER_BUNDLE.getString("AS-WEB-CORE-00019"));
                    return AuthenticationStatus.SEND_FAILURE;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            } else {
                return httpMsgContext.responseUnauthorized();
            }
        }
        return httpMsgContext.doNothing();
    }

    private X509Certificate[] getCertificates(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            certs = (X509Certificate[])request.getAttribute("org.apache.coyote.request.X509Certificate");
        }
        return certs;
    }
}

