/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class DeleteNodeRemoteCommand
implements AdminCommand {
    private static final int DEFAULT_TIMEOUT_MSEC = 300000;
    private static final String NL = System.getProperty("line.separator");
    @Param(name="name", primary=true)
    String name;
    @Param(optional=true, defaultValue="false")
    boolean uninstall;
    @Param(optional=true, defaultValue="false")
    boolean force;
    @Inject
    protected ServiceLocator serviceLocator;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    IterableProvider<Node> nodeList;
    @Inject
    Nodes nodes;
    protected String remotepassword;
    protected String sshkeypassphrase;
    protected Logger logger;

    protected abstract List<String> getPasswords();

    protected abstract String getUninstallCommandName();

    protected abstract void setTypeSpecificOperands(List<String> var1, ParameterMap var2);

    protected final void executeInternal(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.logger = context.getLogger();
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        String type = node.getType();
        if (type == null || type.equals("CONFIG")) {
            String msg = Strings.get("notRemoteNodeType", this.name);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ParameterMap info = new ParameterMap();
        if (this.uninstall) {
            SshConnector sshC = node.getSshConnector();
            SshAuth sshAuth = sshC.getSshAuth();
            if (sshAuth.getPassword() != null) {
                info.add((Object)"sshpassword", (Object)sshAuth.getPassword());
            }
            if (sshAuth.getKeyPassphrase() != null) {
                info.add((Object)"sshkeypassphrase", (Object)sshAuth.getKeyPassphrase());
            }
            if (sshAuth.getKeyfile() != null) {
                info.add((Object)"sshkeyfile", (Object)sshAuth.getKeyfile());
            }
            info.add((Object)"installdir", (Object)node.getInstallDir());
            info.add((Object)"sshport", (Object)sshC.getSshPort());
            info.add((Object)"sshuser", (Object)sshAuth.getUserName());
            info.add((Object)"nodehost", (Object)node.getNodeHost());
            info.add((Object)"windowsdomain", (Object)node.getWindowsDomain());
        }
        CommandRunner.CommandInvocation commandInvocation = this.commandRunner.getCommandInvocation("_delete-node", report, context.getSubject());
        ParameterMap commandParameters = new ParameterMap();
        commandParameters.add((Object)"DEFAULT", (Object)this.name);
        commandInvocation.parameters(commandParameters);
        commandInvocation.execute();
        if (this.uninstall && !this.uninstallNode(context, info, node) && !this.force) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private boolean uninstallNode(AdminCommandContext ctx, ParameterMap map, Node node) {
        boolean res = false;
        this.remotepassword = (String)map.getOne((Object)"sshpassword");
        this.sshkeypassphrase = (String)map.getOne((Object)"sshkeypassphrase");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getUninstallCommandName());
        command.add("--installdir");
        command.add((String)map.getOne((Object)"installdir"));
        if (this.force) {
            command.add("--force");
        }
        this.setTypeSpecificOperands(command, map);
        String host = (String)map.getOne((Object)"nodehost");
        command.add(host);
        String firstErrorMessage = Strings.get("delete.node.ssh.uninstall.failed", node.getName(), host);
        StringBuilder out = new StringBuilder();
        int exitCode = this.execCommand(command, out);
        this.logger.info(out.toString().trim());
        ActionReport report = ctx.getActionReport();
        if (exitCode == 0) {
            report.setMessage(Strings.get("delete.node.ssh.uninstall.success", host));
            res = true;
        } else {
            report.setMessage(firstErrorMessage);
        }
        return res;
    }

    private int execCommand(List<String> cmdLine, StringBuilder output) {
        int exit = -1;
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = this.nodes.getDefaultLocalNode().getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok((String)installDir)) {
            throw new IllegalArgumentException(Strings.get("create.node.ssh.no.installdir"));
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation((String)installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        List<Object> passwords = new ArrayList();
        if (this.remotepassword != null) {
            fullcommand.add("--passwordfile");
            fullcommand.add("-");
            passwords = this.getPasswords();
        }
        fullcommand.add("--interactive=false");
        fullcommand.addAll(cmdLine);
        ProcessManager processManager = new ProcessManager(fullcommand);
        if (!passwords.isEmpty()) {
            processManager.setStdinLines(passwords);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Running command on DAS: " + this.commandListToString(fullcommand));
        }
        processManager.setTimeoutMsec(300000);
        if (this.logger.isLoggable(Level.FINER)) {
            processManager.setEcho(true);
        } else {
            processManager.setEcho(false);
        }
        try {
            exit = processManager.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing command: " + ex.getMessage());
            }
            exit = 1;
        }
        String stdout = processManager.getStdout();
        String stderr = processManager.getStderr();
        if (output != null) {
            if (StringUtils.ok((String)stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok((String)stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        return exit;
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String commandPart : command) {
            fullCommand.append(" ");
            fullCommand.append(commandPart);
        }
        return fullCommand.toString();
    }
}

