/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.util.DOLUtils;
import fish.payara.cluster.Clustered;
import fish.payara.micro.cdi.extension.cluster.ClusteredSingletonLookupImpl;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScoped;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.soteria.cdi.CdiUtils;

class ClusterScopeContext
implements Context {
    private final BeanManager beanManager;
    private final ClusteredSingletonLookupImpl clusteredLookup;

    public ClusterScopeContext(BeanManager beanManager, Deployment deployment) {
        this.beanManager = beanManager;
        Application app = (Application)deployment.getCurrentDeploymentContext().getModuleMetaData(Application.class);
        this.clusteredLookup = new ClusteredSingletonLookupImpl(beanManager, DOLUtils.getApplicationName((JndiNameEnvironment)app));
    }

    public Class<? extends Annotation> getScope() {
        return ClusterScoped.class;
    }

    public <TT> TT get(Contextual<TT> contextual, CreationalContext<TT> creationalContext) {
        TT beanInstance = this.get(contextual);
        if (beanInstance == null) {
            beanInstance = this.getFromApplicationScoped(contextual, Optional.of(creationalContext));
            Bean bean = (Bean)contextual;
            if (this.clusteredLookup.getClusteredSingletonMap().putIfAbsent((Object)ClusterScopeContext.getBeanName(bean, ClusterScopeContext.getAnnotation(this.beanManager, bean)), beanInstance) != null) {
                bean.destroy(beanInstance, creationalContext);
                beanInstance = this.get(contextual);
            }
        }
        return beanInstance;
    }

    public <TT> TT get(Contextual<TT> contextual) {
        Bean bean = (Bean)contextual;
        Clustered clusteredAnnotation = ClusterScopeContext.getAnnotation(this.beanManager, bean);
        String beanName = ClusterScopeContext.getBeanName(bean, clusteredAnnotation);
        Object beanInstance = this.clusteredLookup.getClusteredSingletonMap().get((Object)beanName);
        if (clusteredAnnotation.callPostConstructOnAttach() && beanInstance != null && this.getFromApplicationScoped(contextual, Optional.empty()) == null) {
            this.beanManager.getContext(ApplicationScoped.class).get(contextual, this.beanManager.createCreationalContext(contextual));
        }
        return (TT)beanInstance;
    }

    public boolean isActive() {
        return true;
    }

    private <TT> TT getFromApplicationScoped(Contextual<TT> contextual, Optional<CreationalContext<TT>> creationalContext) {
        if (creationalContext.isPresent()) {
            return (TT)this.beanManager.getContext(ApplicationScoped.class).get(contextual, creationalContext.get());
        }
        return (TT)this.beanManager.getContext(ApplicationScoped.class).get(contextual);
    }

    static <TT> String getBeanName(Bean<TT> bean, Clustered annotation) {
        try {
            return ClusterScopeContext.firstNonNull(annotation.keyName(), bean.getName(), bean.getBeanClass().getName());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not find the name for bean: " + bean.toString(), t);
        }
    }

    static <TT> Clustered getAnnotation(BeanManager beanManager, Bean<TT> bean) {
        return ClusterScopeContext.getAnnotation(beanManager, bean.getBeanClass());
    }

    static <TT> Clustered getAnnotation(BeanManager beanManager, Class<?> clazz) {
        return (Clustered)CdiUtils.getAnnotation((BeanManager)beanManager, clazz, Clustered.class).get();
    }

    private static String firstNonNull(String ... items) {
        for (String i : items) {
            if (i == null || i.trim().isEmpty()) continue;
            return i;
        }
        throw new IllegalArgumentException("All elements were null.");
    }
}

