/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification;

import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraConfiguredNotifier;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.internal.notification.PayaraNotifierConfiguration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceHandle;

public class NotifierHandler
implements Consumer<PayaraNotification> {
    private static final Logger LOGGER = Logger.getLogger(NotifierHandler.class.getName());
    private final PayaraNotifier notifier;
    private final PayaraNotifierConfiguration config;
    private final String notifierName;
    private final BlockingQueue<PayaraNotification> notificationQueue;
    private final ScheduledExecutorService executor;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private ScheduledFuture<?> taskResult;

    public NotifierHandler(ServiceHandle<PayaraNotifier> notifierHandle) {
        this(notifierHandle, null);
    }

    public NotifierHandler(ServiceHandle<PayaraNotifier> notifierHandle, PayaraNotifierConfiguration config) {
        this.notifier = (PayaraNotifier)notifierHandle.getService();
        this.notifierName = NotifierUtils.getNotifierName(notifierHandle.getActiveDescriptor());
        this.config = config;
        this.notificationQueue = new LinkedBlockingDeque<PayaraNotification>();
        this.executor = Executors.newScheduledThreadPool(1, r -> new Thread(r, this.notifierName + "-" + this.threadNumber.getAndIncrement()));
    }

    protected PayaraNotifierConfiguration getConfig() {
        return this.config;
    }

    protected String getName() {
        return this.notifierName;
    }

    protected void reconfigure() {
        boolean wasEnabled;
        PayaraNotifierConfiguration currentConfig = null;
        if (this.config != null && (currentConfig = (PayaraNotifierConfiguration)((PayaraConfiguredNotifier)PayaraConfiguredNotifier.class.cast(this.notifier)).getConfiguration()) == null) {
            currentConfig = this.config;
        }
        boolean enabled = this.config != null && Boolean.valueOf(this.config.getEnabled()) != false;
        boolean bl = wasEnabled = this.config != null && Boolean.valueOf(currentConfig.getEnabled()) != false;
        if (!enabled) {
            if (wasEnabled) {
                this.destroy();
            }
        } else if (wasEnabled) {
            this.destroy();
            this.bootstrap();
        } else {
            this.bootstrap();
        }
    }

    protected synchronized void destroy() {
        boolean wasEnabled = this.isEnabled();
        if (this.config != null) {
            ((PayaraConfiguredNotifier)PayaraConfiguredNotifier.class.cast(this.notifier)).setConfiguration(this.config);
        }
        if (this.taskResult != null) {
            this.taskResult.cancel(true);
        }
        if (wasEnabled) {
            this.notifier.destroy();
        }
    }

    protected synchronized void bootstrap() {
        if (this.config != null) {
            ((PayaraConfiguredNotifier)PayaraConfiguredNotifier.class.cast(this.notifier)).setConfiguration(this.config);
        }
        if (this.isEnabled()) {
            this.notifier.bootstrap();
            this.taskResult = this.executor.scheduleWithFixedDelay(this::run, 0L, 5L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void accept(PayaraNotification notification) {
        if (this.isEnabled() && !this.notificationQueue.offer(notification)) {
            LOGGER.warning(String.format("Notifier %s failed to accept the notification \"%s\".", this.notifierName, notification));
        }
    }

    private void run() {
        assert (this.isEnabled());
        try {
            PayaraNotification notification = this.notificationQueue.take();
            try {
                if (notification != null) {
                    this.notifier.handleNotification(notification);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, String.format("Notifier %s failed to handle notification \"%s\".", this.notifierName, notification), ex);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, String.format("Cancelled waiting on queue for notifier \"%s\".", this.notifierName), ex);
        }
    }

    private boolean isEnabled() {
        if (this.config != null) {
            return Boolean.valueOf(((PayaraConfiguredNotifier)PayaraConfiguredNotifier.class.cast(this.notifier)).getConfiguration().getEnabled());
        }
        return true;
    }
}

