/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.log;

import fish.payara.enterprise.server.logging.PayaraNotificationFileHandler;
import fish.payara.internal.notification.PayaraConfiguredNotifier;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.nucleus.notification.log.LogNotifierConfiguration;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="log-notifier")
@RunLevel(value=10)
public class LogNotifier
extends PayaraConfiguredNotifier<LogNotifierConfiguration> {
    @Inject
    private ServiceLocator habitat;
    private PayaraNotificationFileHandler handler;
    private Logger logger = Logger.getLogger(LogNotifier.class.getCanonicalName());

    @Override
    public void bootstrap() {
        if (Boolean.valueOf(((LogNotifierConfiguration)this.configuration).getUseSeparateLogFile()).booleanValue()) {
            Handler[] existingHandlers;
            for (Handler handler : existingHandlers = this.logger.getHandlers()) {
                this.logger.removeHandler(handler);
            }
            this.logger.addHandler(this.getHandler());
            this.logger.setUseParentHandlers(false);
        } else {
            if (this.handler != null) {
                this.logger.removeHandler(this.getHandler());
            }
            this.logger.setUseParentHandlers(true);
        }
    }

    @Override
    public void destroy() {
        this.handler = null;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = (PayaraNotificationFileHandler)this.habitat.createAndInitialize(PayaraNotificationFileHandler.class);
        }
        return this.handler;
    }

    @Override
    public void handleNotification(PayaraNotification event) {
        if (Boolean.valueOf(((LogNotifierConfiguration)this.configuration).getEnabled()).booleanValue()) {
            if (event.getSubject() != null) {
                this.logger.info(String.format("%s - %s", event.getSubject(), event.getMessage()));
            } else {
                this.logger.info(event.getMessage());
            }
        }
    }
}

