/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.glassfish.hk2.classmodel.reflect.Type;

public class OpenApiConfiguration {
    private static final Logger LOGGER = Logger.getLogger(OpenApiConfiguration.class.getName());
    private static final String MODEL_READER_KEY = "mp.openapi.model.reader";
    private static final String FILTER_KEY = "mp.openapi.filter";
    private static final String SCAN_LIB_KEY = "mp.openapi.scan.lib";
    private static final String SCAN_DISABLE_KEY = "mp.openapi.scan.disable";
    private static final String SCAN_PACKAGES_KEY = "mp.openapi.scan.packages";
    private static final String SCAN_CLASSES_KEY = "mp.openapi.scan.classes";
    private static final String SCAN_EXCLUDE_PACKAGES_KEY = "mp.openapi.scan.exclude.packages";
    private static final String SCAN_EXCLUDE_CLASSES_KEY = "mp.openapi.scan.exclude.classes";
    private static final String SERVERS_KEY = "mp.openapi.servers";
    private static final String PATH_PREFIX_KEY = "mp.openapi.servers.path.";
    private static final String OPERATION_PREFIX_KEY = "mp.openapi.servers.operation.";
    private final Class<? extends OASModelReader> modelReader;
    private final Class<? extends OASFilter> filter;
    private final boolean scanDisable;
    private final boolean scanLib;
    private List<String> scanPackages = new ArrayList<String>();
    private List<String> scanClasses = new ArrayList<String>();
    private List<String> excludePackages = new ArrayList<String>();
    private List<String> excludeClasses = new ArrayList<String>();
    private List<String> servers = new ArrayList<String>();
    private Map<String, Set<String>> pathServerMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> operationServerMap = new HashMap<String, Set<String>>();

    public OpenApiConfiguration(ClassLoader applicationClassLoader) {
        if (applicationClassLoader == null) {
            applicationClassLoader = this.getClass().getClassLoader();
        }
        Config config = ConfigProvider.getConfig(applicationClassLoader);
        this.modelReader = this.findModelReaderFromConfig(config, applicationClassLoader);
        this.filter = this.findFilterFromConfig(config, applicationClassLoader);
        this.scanDisable = OpenApiConfiguration.findScanDisableFromConfig(config);
        this.scanLib = OpenApiConfiguration.findScanLibFromConfig(config);
        this.scanPackages = OpenApiConfiguration.findScanPackagesFromConfig(config);
        this.scanClasses = this.findScanClassesFromConfig(config);
        this.excludePackages = OpenApiConfiguration.findExcludePackages(config);
        this.excludeClasses = this.findExcludeClasses(config);
        this.servers = OpenApiConfiguration.findServers(config);
        this.pathServerMap = OpenApiConfiguration.findPathServerMap(config);
        this.operationServerMap = OpenApiConfiguration.findOperationServerMap(config);
    }

    public Class<? extends OASModelReader> getModelReader() {
        return this.modelReader;
    }

    public Class<? extends OASFilter> getFilter() {
        return this.filter;
    }

    public boolean getScanDisable() {
        return this.scanDisable;
    }

    public boolean getScanLib() {
        return this.scanLib;
    }

    public List<String> getScanPackages() {
        return this.scanPackages;
    }

    public List<String> getScanClasses() {
        return this.scanClasses;
    }

    public List<String> getExcludePackages() {
        return this.excludePackages;
    }

    public List<String> getExcludeClasses() {
        return this.excludeClasses;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public Map<String, Set<String>> getPathServerMap() {
        return this.pathServerMap;
    }

    public Map<String, Set<String>> getOperationServerMap() {
        return this.operationServerMap;
    }

    public Set<Type> getValidClasses(Collection<Type> types) {
        return types.stream().filter(type -> this.scanClasses.isEmpty() || this.scanClasses.contains(type.getName())).filter(type -> this.excludeClasses.isEmpty() || !this.excludeClasses.contains(type.getName())).filter(type -> this.scanPackages.isEmpty() || this.scanPackages.stream().anyMatch(pkg -> type.getName().startsWith((String)pkg))).filter(clazz -> this.excludePackages.isEmpty() || this.excludePackages.stream().noneMatch(pkg -> clazz.getName().startsWith((String)pkg))).collect(Collectors.toSet());
    }

    private Class<? extends OASModelReader> findModelReaderFromConfig(Config config, ClassLoader classLoader) {
        try {
            String modelReaderClassName = config.getValue(MODEL_READER_KEY, String.class);
            Class<?> modelReaderClass = this.getClassFromName(modelReaderClassName, classLoader);
            if (modelReaderClass != null && OASModelReader.class.isAssignableFrom(modelReaderClass)) {
                return modelReaderClass;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    private Class<? extends OASFilter> findFilterFromConfig(Config config, ClassLoader classLoader) {
        try {
            String filterClassName = config.getValue(FILTER_KEY, String.class);
            Class<?> filterClass = this.getClassFromName(filterClassName, classLoader);
            if (filterClass != null && OASFilter.class.isAssignableFrom(filterClass)) {
                return filterClass;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    private static boolean findScanDisableFromConfig(Config config) {
        try {
            return config.getValue(SCAN_DISABLE_KEY, Boolean.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    private static boolean findScanLibFromConfig(Config config) {
        try {
            return config.getValue(SCAN_LIB_KEY, Boolean.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    private static List<String> findScanPackagesFromConfig(Config config) {
        ArrayList<String> packages = new ArrayList<String>();
        try {
            packages.addAll(Arrays.asList((Object[])config.getValue(SCAN_PACKAGES_KEY, String[].class)));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return packages;
    }

    private List<String> findScanClassesFromConfig(Config config) {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            List<Object> classNames = Arrays.asList((Object[])config.getValue(SCAN_CLASSES_KEY, String[].class));
            for (String string : classNames) {
                classes.add(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return classes;
    }

    private static List<String> findExcludePackages(Config config) {
        ArrayList<String> packages = new ArrayList<String>();
        try {
            packages.addAll(Arrays.asList((Object[])config.getValue(SCAN_EXCLUDE_PACKAGES_KEY, String[].class)));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return packages;
    }

    private List<String> findExcludeClasses(Config config) {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            List<Object> classNames = Arrays.asList((Object[])config.getValue(SCAN_EXCLUDE_CLASSES_KEY, String[].class));
            for (String string : classNames) {
                classes.add(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return classes;
    }

    private static List<String> findServers(Config config) {
        ArrayList<String> serverList = new ArrayList<String>();
        try {
            serverList.addAll(Arrays.asList((Object[])config.getValue(SERVERS_KEY, String[].class)));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return serverList;
    }

    private static Map<String, Set<String>> findPathServerMap(Config config) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        try {
            for (String propertyName : config.getPropertyNames()) {
                if (!propertyName.startsWith(PATH_PREFIX_KEY)) continue;
                map.put(propertyName.replaceFirst(PATH_PREFIX_KEY, ""), new HashSet<Object>(Arrays.asList((Object[])config.getValue(propertyName, String[].class))));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return map;
    }

    private static Map<String, Set<String>> findOperationServerMap(Config config) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        try {
            for (String propertyName : config.getPropertyNames()) {
                if (!propertyName.startsWith(OPERATION_PREFIX_KEY)) continue;
                map.put(propertyName.replaceFirst(OPERATION_PREFIX_KEY, ""), new HashSet<Object>(Arrays.asList((Object[])config.getValue(propertyName, String[].class))));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return map;
    }

    private Class<?> getClassFromName(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (className == null) {
            return null;
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "Unable to find class.", ex);
            return null;
        }
    }
}

