/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.callbacks.CallbackImpl;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.headers.HeaderImpl;
import fish.payara.microprofile.openapi.impl.model.links.LinkImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.ParameterImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponseImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecuritySchemeImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ComponentsImpl
extends ExtensibleImpl<Components>
implements Components {
    protected Map<String, Schema> schemas = new TreeMap<String, Schema>();
    protected Map<String, APIResponse> responses = new TreeMap<String, APIResponse>();
    protected Map<String, Parameter> parameters = new TreeMap<String, Parameter>();
    protected Map<String, Example> examples = new TreeMap<String, Example>();
    protected Map<String, RequestBody> requestBodies = new TreeMap<String, RequestBody>();
    protected Map<String, Header> headers = new TreeMap<String, Header>();
    protected Map<String, SecurityScheme> securitySchemes = new TreeMap<String, SecurityScheme>();
    protected Map<String, Link> links = new TreeMap<String, Link>();
    protected Map<String, Callback> callbacks = new TreeMap<String, Callback>();

    public static Components createInstance(AnnotationModel annotation, ApiContext context) {
        ComponentsImpl from = new ComponentsImpl();
        ModelUtils.extractAnnotations(annotation, context, "schemas", "name", SchemaImpl::createInstance, from.getSchemas());
        ModelUtils.extractAnnotations(annotation, context, "responses", "name", APIResponseImpl::createInstance, from.getResponses());
        ModelUtils.extractAnnotations(annotation, context, "parameters", "name", ParameterImpl::createInstance, from.getParameters());
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, from.getExamples());
        ModelUtils.extractAnnotations(annotation, context, "requestBodies", "name", RequestBodyImpl::createInstance, from.getRequestBodies());
        ModelUtils.extractAnnotations(annotation, context, "securitySchemes", "securitySchemeName", SecuritySchemeImpl::createInstance, from.getSecuritySchemes());
        ModelUtils.extractAnnotations(annotation, context, "links", "name", LinkImpl::createInstance, from.getLinks());
        ModelUtils.extractAnnotations(annotation, context, "callbacks", "name", CallbackImpl::createInstance, from.getCallbacks());
        from.getHeaders().putAll(HeaderImpl.createInstances(annotation, context));
        return from;
    }

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Map<String, Schema> schemas) {
        this.schemas = schemas;
    }

    public Components addSchema(String key, Schema schema) {
        if (schema != null) {
            this.schemas.put(key, schema);
        }
        return this;
    }

    public void removeSchema(String key) {
        this.schemas.remove(key);
    }

    public Map<String, APIResponse> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, APIResponse> responses) {
        this.responses = responses;
    }

    public Components addResponse(String key, APIResponse response) {
        if (response != null) {
            this.responses.put(key, response);
        }
        return this;
    }

    public void removeResponse(String key) {
        this.responses.remove(key);
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public Components addParameter(String key, Parameter parameter) {
        if (parameter != null) {
            this.parameters.put(key, parameter);
        }
        return this;
    }

    public void removeParameter(String key) {
        this.parameters.remove(key);
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    public Components addExample(String key, Example example) {
        if (example != null) {
            this.examples.put(key, example);
        }
        return this;
    }

    public void removeExample(String key) {
        this.examples.remove(key);
    }

    public Map<String, RequestBody> getRequestBodies() {
        return this.requestBodies;
    }

    public void setRequestBodies(Map<String, RequestBody> requestBodies) {
        this.requestBodies = requestBodies;
    }

    public Components addRequestBody(String key, RequestBody requestBody) {
        if (requestBody != null) {
            this.requestBodies.put(key, requestBody);
        }
        return this;
    }

    public void removeRequestBody(String key) {
        this.requestBodies.remove(key);
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Header> headers) {
        this.headers = headers;
    }

    public Components addHeader(String key, Header header) {
        if (header != null) {
            this.headers.put(key, header);
        }
        return this;
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public Components addSecurityScheme(String key, SecurityScheme securityScheme) {
        if (securityScheme != null) {
            this.securitySchemes.put(key, securityScheme);
        }
        return this;
    }

    public void removeSecurityScheme(String key) {
        this.securitySchemes.remove(key);
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Components addLink(String key, Link link) {
        if (link != null) {
            this.links.put(key, link);
        }
        return this;
    }

    public void removeLink(String key) {
        this.links.remove(key);
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = callbacks;
    }

    public Components addCallback(String key, Callback callback) {
        if (callback != null) {
            this.callbacks.put(key, callback);
        }
        return this;
    }

    public void removeCallback(String key) {
        this.callbacks.remove(key);
    }

    public static void merge(Components from, Components to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        if (from.getSchemas() != null) {
            for (String schemaName : from.getSchemas().keySet()) {
                if (schemaName == null) continue;
                SchemaImpl newSchema = new SchemaImpl();
                SchemaImpl.merge((Schema)from.getSchemas().get(schemaName), newSchema, override, context);
                to.addSchema(schemaName, (Schema)newSchema);
            }
        }
        if (from.getCallbacks() != null) {
            for (String callbackName : from.getCallbacks().keySet()) {
                if (callbackName == null) continue;
                CallbackImpl newCallback = new CallbackImpl();
                CallbackImpl.merge((Callback)from.getCallbacks().get(callbackName), newCallback, override, context);
                to.addCallback(callbackName, (Callback)newCallback);
            }
        }
        if (from.getExamples() != null) {
            for (String exampleName : from.getExamples().keySet()) {
                if (exampleName == null) continue;
                ExampleImpl newExample = new ExampleImpl();
                ExampleImpl.merge((Example)from.getExamples().get(exampleName), newExample, override);
                to.addExample(exampleName, (Example)newExample);
            }
        }
        if (from.getHeaders() != null) {
            for (String headerName : from.getHeaders().keySet()) {
                if (headerName == null) continue;
                HeaderImpl newHeader = new HeaderImpl();
                HeaderImpl.merge((Header)from.getHeaders().get(headerName), newHeader, override, context);
                to.addHeader(headerName, (Header)newHeader);
            }
        }
        if (from.getLinks() != null) {
            for (String linkName : from.getLinks().keySet()) {
                if (linkName == null) continue;
                LinkImpl newLink = new LinkImpl();
                LinkImpl.merge((Link)from.getLinks().get(linkName), newLink, override);
                to.addLink(linkName, (Link)newLink);
            }
        }
        if (from.getParameters() != null) {
            for (String parameterName : from.getParameters().keySet()) {
                if (parameterName == null) continue;
                ParameterImpl newParameter = new ParameterImpl();
                ParameterImpl.merge((Parameter)from.getParameters().get(parameterName), newParameter, override, context);
                to.addParameter(parameterName, (Parameter)newParameter);
            }
        }
        if (from.getRequestBodies() != null) {
            for (String requestBodyName : from.getRequestBodies().keySet()) {
                if (requestBodyName == null) continue;
                RequestBodyImpl newRequestBody = new RequestBodyImpl();
                RequestBodyImpl.merge((RequestBody)from.getRequestBodies().get(requestBodyName), newRequestBody, override, context);
                to.addRequestBody(requestBodyName, (RequestBody)newRequestBody);
            }
        }
        if (from.getResponses() != null) {
            for (String responseName : from.getResponses().keySet()) {
                if (responseName == null) continue;
                APIResponseImpl newResponse = new APIResponseImpl();
                APIResponseImpl.merge((APIResponse)from.getResponses().get(responseName), newResponse, override, context);
                to.addResponse(responseName, (APIResponse)newResponse);
            }
        }
        if (from.getSecuritySchemes() != null) {
            for (String securitySchemeName : from.getSecuritySchemes().keySet()) {
                if (securitySchemeName == null) continue;
                SecuritySchemeImpl newSecurity = new SecuritySchemeImpl();
                SecuritySchemeImpl.merge((SecurityScheme)from.getSecuritySchemes().get(securitySchemeName), newSecurity, override);
                to.addSecurityScheme(securitySchemeName, (SecurityScheme)newSecurity);
            }
        }
    }
}

