/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.models.Extensible;

public abstract class ExtensibleImpl<T extends Extensible<T>>
implements Extensible<T> {
    private static final Logger LOGGER = Logger.getLogger(ExtensibleImpl.class.getName());
    @JsonIgnore
    protected Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public T addExtension(String name, Object value) {
        if (value != null) {
            this.extensions.put(ExtensibleImpl.extensionName(name), value);
        }
        return (T)this;
    }

    public void removeExtension(String name) {
        this.extensions.remove(ExtensibleImpl.extensionName(name));
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions.clear();
        for (Map.Entry<String, Object> entry : extensions.entrySet()) {
            this.extensions.put(ExtensibleImpl.extensionName(entry.getKey()), entry.getValue());
        }
    }

    public static String extensionName(String name) {
        if (name != null && !name.startsWith("x-")) {
            LOGGER.log(Level.WARNING, "extension name not starting with `x-` cause invalid Open API documents: {0}", name);
        }
        return name;
    }

    public static void merge(Extensible<?> from, Extensible<?> to, boolean override) {
        if (from == null) {
            return;
        }
        if (to.getExtensions() == null) {
            to.setExtensions(new LinkedHashMap());
        }
        if (!from.getExtensions().isEmpty()) {
            for (String extensionName : from.getExtensions().keySet()) {
                Object value = ModelUtils.mergeProperty(to.getExtensions().get(extensionName), from.getExtensions().get(extensionName), override);
                to.getExtensions().put(extensionName, value);
            }
        }
    }

    public static Object convertExtensionValue(String value, boolean parseValue) {
        String[] possibleArray;
        if (value == null) {
            return null;
        }
        if (parseValue) {
            try {
                JsonNode node = new ObjectMapper().readTree(value);
                if (node.isBoolean()) {
                    return node.booleanValue();
                }
                if (node.isNumber()) {
                    return node.numberValue();
                }
                return node;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to parse extension value: {0}", value);
                return value;
            }
        }
        if (value.contains(",") && (possibleArray = value.replaceAll("^[\\[\\{\\(]", "").replaceAll("[\\]\\}\\)]$", "").split(",")).length > 1) {
            return possibleArray;
        }
        return value;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.toString(str, "\t");
        return str.toString();
    }

    void toString(StringBuilder str, String indent) {
        str.append('[').append(this.getClass().getSimpleName()).append("] {");
        for (Class<?> type = this.getClass(); type != Object.class; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(this);
                    ExtensibleImpl.toString(str, indent, field.getName(), value);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    str.append("<failure:").append(e.getMessage()).append(">");
                }
            }
        }
        str.append('\n').append(indent.length() > 0 ? indent.substring(1) : indent).append('}');
    }

    private static void toString(StringBuilder str, String indent, Object key, Object value) {
        if (ExtensibleImpl.isNonEmpty(value)) {
            str.append("\n").append(indent);
            if (key != null) {
                str.append('\"').append(key).append('\"').append(": ");
            }
            if (value instanceof ExtensibleImpl) {
                ((ExtensibleImpl)value).toString(str, indent + "\t");
            } else if (value instanceof Map) {
                str.append('{');
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    ExtensibleImpl.toString(str, indent + '\t', entry.getKey(), entry.getValue());
                }
                str.append('\n').append(indent).append('}');
            } else if (value instanceof Collection) {
                str.append('[');
                for (Object element : (Collection)value) {
                    ExtensibleImpl.toString(str, indent + '\t', null, element);
                    str.append(',');
                }
                str.append('\n').append(indent).append(']');
            } else if (value instanceof String) {
                str.append('\"').append(value).append('\"');
            } else {
                str.append(value);
            }
        }
    }

    private static boolean isNonEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length > 0;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        return true;
    }
}

