/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import fish.payara.microprofile.openapi.impl.model.callbacks.CallbackImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.ParameterImpl;
import fish.payara.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponseImpl;
import fish.payara.microprofile.openapi.impl.model.responses.APIResponsesImpl;
import fish.payara.microprofile.openapi.impl.model.security.SecurityRequirementImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class OperationImpl
extends ExtensibleImpl<Operation>
implements Operation {
    protected List<String> tags = new ArrayList<String>();
    protected String summary;
    protected String description;
    protected ExternalDocumentation externalDocs;
    protected String operationId;
    protected List<Parameter> parameters = new ArrayList<Parameter>();
    protected RequestBody requestBody;
    protected APIResponses responses = new APIResponsesImpl();
    protected Map<String, Callback> callbacks = new HashMap<String, Callback>();
    protected Boolean deprecated;
    protected List<SecurityRequirement> security = new ArrayList<SecurityRequirement>();
    protected List<Server> servers = new ArrayList<Server>();
    protected String method;

    public static Operation createInstance(AnnotationModel annotation, ApiContext context) {
        OperationImpl from = new OperationImpl();
        from.setSummary((String)annotation.getValue("summary", String.class));
        from.setDescription((String)annotation.getValue("description", String.class));
        AnnotationModel externalDocs = (AnnotationModel)annotation.getValue("externalDocs", AnnotationModel.class);
        if (externalDocs != null) {
            from.setExternalDocs(ExternalDocumentationImpl.createInstance(externalDocs));
        }
        from.setOperationId((String)annotation.getValue("operationId", String.class));
        ModelUtils.extractAnnotations(annotation, context, "parameters", ParameterImpl::createInstance, from.getParameters());
        AnnotationModel requestBody = (AnnotationModel)annotation.getValue("requestBody", AnnotationModel.class);
        if (requestBody != null) {
            from.setRequestBody(RequestBodyImpl.createInstance(requestBody, context));
        }
        ModelUtils.extractAnnotations(annotation, context, "responses", "responseCode", APIResponseImpl::createInstance, from.getResponses());
        ModelUtils.extractAnnotations(annotation, context, "callbacks", "name", CallbackImpl::createInstance, from.getCallbacks());
        from.setDeprecated((Boolean)annotation.getValue("deprecated", Boolean.class));
        ModelUtils.extractAnnotations(annotation, context, "security", SecurityRequirementImpl::createInstance, from.getSecurity());
        ModelUtils.extractAnnotations(annotation, context, "servers", ServerImpl::createInstance, from.getServers());
        from.setMethod((String)annotation.getValue("method", String.class));
        return from;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Operation addTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Operation addParameter(Parameter parameter) {
        if (parameter != null) {
            this.parameters.add(parameter);
        }
        return this;
    }

    public void removeParameter(Parameter parameter) {
        this.parameters.remove(parameter);
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public APIResponses getResponses() {
        return this.responses;
    }

    public void setResponses(APIResponses responses) {
        this.responses = responses;
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = callbacks;
    }

    public Operation addCallback(String key, Callback callback) {
        if (callback != null) {
            this.callbacks.put(key, callback);
        }
        return this;
    }

    public void removeCallback(String key) {
        this.callbacks.remove(key);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Operation deprecated(Boolean deprecated) {
        this.setDeprecated(deprecated);
        return this;
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRequirement> security) {
        this.security = security;
    }

    public Operation addSecurityRequirement(SecurityRequirement securityReq) {
        this.security.add(securityReq);
        return this;
    }

    public void removeSecurityRequirement(SecurityRequirement securityRequirement) {
        this.security.remove(securityRequirement);
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public Operation addServer(Server server) {
        this.servers.add(server);
        return this;
    }

    public void removeServer(Server server) {
        this.servers.remove(server);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public static void merge(Operation from, Operation to, boolean override) {
        if (from == null) {
            return;
        }
        to.setOperationId(ModelUtils.mergeProperty(to.getOperationId(), from.getOperationId(), override));
        to.setSummary(ModelUtils.mergeProperty(to.getSummary(), from.getSummary(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        to.setDeprecated(ModelUtils.mergeProperty(to.getDeprecated(), from.getDeprecated(), override));
    }

    public static void merge(Operation from, Operation to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        to.setSummary(ModelUtils.mergeProperty(to.getSummary(), from.getSummary(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        if (from.getExtensions() != null) {
            ExtensibleImpl.merge(from, to, override);
        }
        if (from.getExternalDocs() != null) {
            if (to.getExternalDocs() == null) {
                to.setExternalDocs((ExternalDocumentation)new ExternalDocumentationImpl());
            }
            ExternalDocumentationImpl.merge(from.getExternalDocs(), to.getExternalDocs(), override);
        }
        if (from.getParameters() != null) {
            for (Parameter parameter : from.getParameters()) {
                ParameterImpl newParameter = new ParameterImpl();
                ParameterImpl.merge(parameter, newParameter, override, context);
            }
        }
        if (from.getRequestBody() != null) {
            if (to.getRequestBody() == null) {
                to.setRequestBody((RequestBody)new RequestBodyImpl());
            }
            RequestBodyImpl.merge(from.getRequestBody(), to.getRequestBody(), override, context);
        }
        if (from.getResponses() != null) {
            for (APIResponse response : from.getResponses().values()) {
                APIResponsesImpl.merge(response, to.getResponses(), override, context);
            }
        }
    }
}

