/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.servers;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerVariableImpl;
import fish.payara.microprofile.openapi.impl.model.servers.ServerVariablesImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.eclipse.microprofile.openapi.models.servers.ServerVariables;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ServerImpl
extends ExtensibleImpl<Server>
implements Server {
    private String url;
    private String description;
    private Map<String, ServerVariable> variables;

    public static Server createInstance(AnnotationModel annotation, ApiContext context) {
        ServerImpl from = new ServerImpl();
        from.setDescription((String)annotation.getValue("description", String.class));
        from.setUrl((String)annotation.getValue("url", String.class));
        HashMap variables = new HashMap();
        ModelUtils.extractAnnotations(annotation, context, "variables", "name", ServerVariableImpl::createInstance, variables);
        from.setVariables(variables);
        return from;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServerVariables getVariables() {
        return this.variables instanceof ServerVariables || this.variables == null ? (ServerVariables)this.variables : new ServerVariablesImpl(this.variables);
    }

    public void setVariables(ServerVariables variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, ServerVariable> variables) {
        this.variables = variables;
    }

    public static void merge(Server from, Server to, boolean override) {
        if (from == null) {
            return;
        }
        to.setUrl(ModelUtils.mergeProperty(to.getUrl(), from.getUrl(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        if (from.getVariables() != null) {
            if (to.getVariables() == null) {
                to.setVariables((ServerVariables)new ServerVariablesImpl());
            }
            for (String serverVariableName : from.getVariables().keySet()) {
                ServerVariablesImpl.merge(serverVariableName, from.getVariables().get((Object)serverVariableName), to.getVariables(), override);
            }
        }
    }
}

