/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.tags;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.ExtensibleImpl;
import fish.payara.microprofile.openapi.impl.model.ExternalDocumentationImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class TagImpl
extends ExtensibleImpl<Tag>
implements Tag {
    private String name;
    private String description;
    private ExternalDocumentation externalDocs;
    private String ref;

    public static Tag createInstance(AnnotationModel annotation, ApiContext context) {
        String ref;
        TagImpl from = new TagImpl();
        from.setName((String)annotation.getValue("name", String.class));
        from.setDescription((String)annotation.getValue("description", String.class));
        AnnotationModel externalDocs = (AnnotationModel)annotation.getValue("externalDocs", AnnotationModel.class);
        if (externalDocs != null) {
            from.setExternalDocs(ExternalDocumentationImpl.createInstance(externalDocs));
        }
        if ((ref = (String)annotation.getValue("ref", String.class)) != null && !ref.isEmpty()) {
            from.setRef(ref);
        }
        return from;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public static void merge(Tag from, Tag to, boolean override) {
        if (from == null) {
            return;
        }
        to.setName(ModelUtils.mergeProperty(to.getName(), from.getName(), override));
        to.setDescription(ModelUtils.mergeProperty(to.getDescription(), from.getDescription(), override));
        if (from.getExternalDocs() != null) {
            if (to.getExternalDocs() == null) {
                to.setExternalDocs((ExternalDocumentation)new ExternalDocumentationImpl());
            }
            ExternalDocumentationImpl.merge(from.getExternalDocs(), to.getExternalDocs(), override);
        }
    }

    public static void merge(Tag from, Operation to, boolean override, List<Tag> apiTags) {
        TagImpl fromImpl;
        if (from == null) {
            return;
        }
        if (from instanceof TagImpl && (fromImpl = (TagImpl)from).getRef() != null && !fromImpl.getRef().isEmpty()) {
            to.addTag(fromImpl.getRef());
            return;
        }
        if (from.getName() != null && !from.getName().isEmpty()) {
            if (!apiTags.contains(from)) {
                TagImpl newTag = new TagImpl();
                TagImpl.merge(from, newTag, true);
                apiTags.add(newTag);
            }
            to.addTag(from.getName());
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagImpl other = (TagImpl)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public String toString() {
        return "TagImpl{name=" + this.name + ", description=" + this.description + ", externalDocs=" + this.externalDocs + ", ref=" + this.ref + '}';
    }
}

