/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.processor;

import fish.payara.microprofile.openapi.api.processor.OASProcessor;
import fish.payara.microprofile.openapi.impl.config.OpenApiConfiguration;
import fish.payara.microprofile.openapi.impl.model.OpenAPIImpl;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class FilterProcessor
implements OASProcessor {
    private static final Logger LOGGER = Logger.getLogger(FilterProcessor.class.getName());
    private OASFilter filter;

    public FilterProcessor() {
        this(null);
    }

    public FilterProcessor(OASFilter filter) {
        this.filter = filter;
    }

    @Override
    public OpenAPI process(OpenAPI api, OpenApiConfiguration config) {
        try {
            if (this.filter == null && config.getFilter() != null) {
                this.filter = config.getFilter().newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.log(Level.WARNING, "Error creating OASFilter instance.", ex);
        }
        if (this.filter != null) {
            return (OpenAPI)this.filterObject(api);
        }
        LOGGER.fine("No OASFilter provided.");
        return api;
    }

    private Object filterObject(Object object) {
        if (object != null) {
            Package pkg;
            Object result;
            ArrayList<Object> resultsToRemove;
            if (object instanceof Map) {
                resultsToRemove = new ArrayList<Object>();
                for (Object object2 : ((Map)Map.class.cast(object)).values()) {
                    result = this.filterObject(object2);
                    if (result != null) continue;
                    resultsToRemove.add(object2);
                }
                for (Object e : resultsToRemove) {
                    ((Map)Map.class.cast(object)).values().remove(e);
                }
            }
            if (object instanceof Iterable) {
                resultsToRemove = new ArrayList();
                for (Object object3 : (Iterable)Iterable.class.cast(object)) {
                    result = this.filterObject(object3);
                    if (result != null) continue;
                    resultsToRemove.add(object3);
                }
                for (Object e : resultsToRemove) {
                    Iterator iterator = ((Iterable)Iterable.class.cast(object)).iterator();
                    while (iterator.hasNext()) {
                        if (!iterator.next().equals(e)) continue;
                        iterator.remove();
                    }
                }
            }
            if ((pkg = object.getClass().getPackage()) != null && pkg.getName().startsWith(OpenAPIImpl.class.getPackage().getName())) {
                for (Field field : object.getClass().getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                        Object fieldValue = field.get(object);
                        Object result2 = this.filterObject(fieldValue);
                        if (result2 != null) continue;
                        field.set(object, null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        LOGGER.log(Level.WARNING, "Unable to access field in OpenAPI model.", ex);
                    }
                }
                object = this.visitObject(object);
            }
            return object;
        }
        return null;
    }

    private Object visitObject(Object object) {
        if (object != null) {
            if (PathItem.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterPathItem((PathItem)object);
            }
            if (Operation.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterOperation((Operation)object);
            }
            if (Parameter.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterParameter((Parameter)object);
            }
            if (Header.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterHeader((Header)object);
            }
            if (RequestBody.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterRequestBody((RequestBody)object);
            }
            if (APIResponse.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterAPIResponse((APIResponse)object);
            }
            if (Schema.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterSchema((Schema)object);
            }
            if (SecurityScheme.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterSecurityScheme((SecurityScheme)object);
            }
            if (Server.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterServer((Server)object);
            }
            if (Tag.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterTag((Tag)object);
            }
            if (Link.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterLink((Link)object);
            }
            if (Callback.class.isAssignableFrom(object.getClass())) {
                return this.filter.filterCallback((Callback)object);
            }
            if (OpenAPI.class.isAssignableFrom(object.getClass())) {
                this.filter.filterOpenAPI((OpenAPI)object);
            }
        }
        return object;
    }
}

