/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class AlpnExtension
extends HelloExtension {
    private static final String ALPN_TO_STRING_MSG = "Application Layer Protocol Extension (ALPN) [0x%x/%d], client protocols: %s, selected protocol: %s, serialized data: %s";
    static final int ID = 16;
    static final String NAME = "alpn";
    String selectedProtocol;
    String[] protocols;
    byte[] outData;

    AlpnExtension(ExtensionType extensionType) {
        super(extensionType);
    }

    int length() {
        return 6 + (short)this.outData.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(16);
        handshakeOutStream.putInt16(this.outData.length + 2);
        handshakeOutStream.putInt16(this.outData.length);
        handshakeOutStream.write(this.outData);
    }

    public String toString() {
        return String.format(ALPN_TO_STRING_MSG, 16, 16, Arrays.toString(this.protocols), this.selectedProtocol, Debug.toString((byte[])this.outData));
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final byte[] EMPTY_DATA = new byte[0];
        private static final String[] NO_PROTOCOLS = new String[0];
        private final AlpnExtension extension = new AlpnExtension(ExtensionType.get(16));
        private HandshakeInStream in;
        private int len;

        Builder() {
        }

        Builder selectedProtocol(String selectedProtocol) {
            this.extension.selectedProtocol = selectedProtocol;
            return this;
        }

        Builder protocols(String[] protocols) {
            this.extension.protocols = protocols;
            return this;
        }

        Builder handshakeIn(HandshakeInStream in, int len) {
            this.in = in;
            this.len = len;
            return this;
        }

        AlpnExtension build() throws IOException {
            if (this.in != null) {
                if (this.len > 0) {
                    byte[] protocol;
                    ArrayList<String> list = new ArrayList<String>(4);
                    int newLen = this.in.getInt16();
                    for (int read = 0; read != newLen; read += protocol.length + 1) {
                        protocol = new byte[this.in.getInt8()];
                        this.in.read(protocol);
                        list.add(new String(protocol, "UTF-8"));
                    }
                    this.extension.protocols = list.toArray(new String[list.size()]);
                } else {
                    this.extension.protocols = NO_PROTOCOLS;
                }
            } else if (this.extension.selectedProtocol != null) {
                byte[] selectedProtocolBytes = this.extension.selectedProtocol.getBytes("UTF-8");
                byte[] outBytes = new byte[selectedProtocolBytes.length + 1];
                outBytes[0] = (byte)selectedProtocolBytes.length;
                System.arraycopy(selectedProtocolBytes, 0, outBytes, 1, selectedProtocolBytes.length);
                this.extension.outData = outBytes;
            } else if (this.extension.protocols.length == 0) {
                this.extension.outData = EMPTY_DATA;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (String protocol : this.extension.protocols) {
                    if (protocol.length() <= 0 || protocol.length() >= 256) continue;
                    out.write((byte)protocol.length());
                    out.write(protocol.getBytes("UTF-8"));
                }
                this.extension.outData = out.toByteArray();
            }
            return this.extension;
        }
    }
}

