/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jaspic;

import fish.payara.security.jaspic.SimpleSAMAuthConfigProvider;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;

public class JASPICWebListenerHelper {
    public static final String SAM_PER_REQUEST_PROPERTY = "fish.payara.security.jaspic.SAMPerRequest";
    private String registrationID;

    public void registerSAM(Class samClass, ServletContextEvent sce, String samDescription) {
        ServletContext sc = sce.getServletContext();
        Enumeration names = sce.getServletContext().getInitParameterNames();
        HashMap<String, String> samProperties = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            samProperties.put(name, sc.getInitParameter(name));
        }
        this.registrationID = AuthConfigFactory.getFactory().registerConfigProvider((AuthConfigProvider)new SimpleSAMAuthConfigProvider(samProperties, null, samClass), "HttpServlet", sce.getServletContext().getVirtualServerName() + " " + sce.getServletContext().getContextPath(), samDescription);
    }

    public void deregisterSAM() {
        AuthConfigFactory.getFactory().removeRegistration(this.registrationID);
    }
}

