/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_create-instance-filesystem")
@PerLookup
public class CreateLocalInstanceFilesystemCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true)
    protected String instanceName0;
    @Param(name="dockerNode", defaultValue="false", optional=true, alias="dockernode")
    protected Boolean dockerNode;
    @Param(name="extraterse", optional=true, shortName="T", defaultValue="false")
    protected boolean extraTerse;
    String DASHost;
    int DASPort = -1;
    String DASProtocol;
    boolean dasIsSecure;
    private File agentConfigDir = null;
    private File dasPropsFile = null;
    private File nodePropsFile = null;
    private Properties dasProperties;
    private Properties nodeProperties;
    protected boolean setDasDefaultsOnly = false;

    @Override
    protected void validate() throws CommandException {
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.instanceName0)) {
            throw new CommandException(Strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        this.isCreateInstanceFilesystem = true;
        super.validate();
        String agentPath = "agent" + File.separator + "config";
        this.agentConfigDir = new File(this.nodeDirChild, agentPath);
        this.dasPropsFile = new File(this.agentConfigDir, "das.properties");
        this.nodePropsFile = new File(this.agentConfigDir, "node.properties");
        if (this.dasPropsFile.isFile()) {
            if (this.programOpts.getHost() != null && !this.programOpts.getHost().equals("localhost")) {
                this.validateDasOptions(this.programOpts.getHost(), String.valueOf(this.programOpts.getPort()), String.valueOf(this.programOpts.isSecure()), this.dasPropsFile);
            }
            this.setDasDefaults(this.dasPropsFile);
            if (!this.setDasDefaultsOnly) {
                String nodeName;
                String nodeDirChildName = this.nodeDirChild != null ? this.nodeDirChild.getName() : "";
                String string = nodeName = this.node != null ? this.node : nodeDirChildName;
                if (!this.programOpts.isTerse()) {
                    logger.info(Strings.get("Instance.existingDasPropertiesWarning", this.programOpts.getHost(), "" + this.programOpts.getPort(), nodeName));
                }
            }
        }
        this.DASHost = this.programOpts.getHost();
        this.DASPort = this.programOpts.getPort();
        this.dasIsSecure = this.programOpts.isSecure();
        this.DASProtocol = "http";
    }

    protected int executeCommand() throws CommandException {
        this.checkDASCoordinates();
        return this.createDirectories();
    }

    private int createDirectories() throws CommandException {
        boolean createDirsComplete = false;
        File badfile = null;
        while (badfile == null && !createDirsComplete) {
            if (!this.agentConfigDir.isDirectory() && !this.agentConfigDir.mkdirs()) {
                badfile = this.agentConfigDir;
            }
            createDirsComplete = true;
        }
        if (badfile != null) {
            throw new CommandException(Strings.get("Instance.cannotMkDir", badfile));
        }
        this.writeProperties();
        return 0;
    }

    private void writeProperties() throws CommandException {
        String filename = "";
        try {
            filename = this.dasPropsFile.getName();
            if (!this.dasPropsFile.isFile()) {
                this.writeDasProperties();
            }
            filename = this.nodePropsFile.getName();
            if (!this.nodePropsFile.isFile()) {
                this.writeNodeProperties();
            }
        }
        catch (IOException ex) {
            throw new CommandException(Strings.get("Instance.cantWriteProperties", filename), (Throwable)ex);
        }
    }

    private void writeDasProperties() throws IOException {
        if (this.dasPropsFile.createNewFile()) {
            this.dasProperties = new Properties();
            this.dasProperties.setProperty("agent.das.host", this.DASHost);
            this.dasProperties.setProperty("agent.das.port", String.valueOf(this.DASPort));
            this.dasProperties.setProperty("agent.das.isSecure", String.valueOf(this.dasIsSecure));
            this.dasProperties.setProperty("agent.das.protocol", this.DASProtocol);
            try (FileOutputStream fos = new FileOutputStream(this.dasPropsFile);){
                this.dasProperties.store(fos, Strings.get("Instance.dasPropertyComment"));
            }
        }
    }

    private void writeNodeProperties() throws IOException {
        if (this.nodePropsFile.createNewFile()) {
            this.nodeProperties = new Properties();
            this.nodeProperties.setProperty("agent.node.docker", this.dockerNode.toString());
            try (FileOutputStream fos = new FileOutputStream(this.nodePropsFile);){
                this.nodeProperties.store(fos, Strings.get("Instance.nodePropertyComment"));
            }
        }
    }

    private void checkDASCoordinates() throws CommandException {
        try {
            InetAddress.getByName(this.DASHost);
        }
        catch (UnknownHostException e) {
            String thisHost = NetUtils.getHostName();
            String msg = Strings.get("Instance.DasHostUnknown", this.DASHost, thisHost);
            throw new CommandException(msg, (Throwable)e);
        }
        if (!NetUtils.isRunning((String)this.DASHost, (int)this.DASPort)) {
            String thisHost = NetUtils.getHostName();
            String msg = Strings.get("Instance.DasHostUnreachable", this.DASHost, Integer.toString(this.DASPort), thisHost);
            throw new CommandException(msg);
        }
    }
}

