/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.jmxmp;

import com.sun.jmx.remote.socket.SocketConnectionServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.GenericConnectorServer;

public class JMXMPConnectorServer
extends GenericConnectorServer {
    public static final String SERVER_ADDRESS_WILDCARD = "jmx.remote.server.address.wildcard";

    public JMXMPConnectorServer() throws IOException {
        this((MBeanServer)null);
    }

    public JMXMPConnectorServer(MBeanServer mbs) throws IOException {
        this(null, null, mbs);
    }

    public JMXMPConnectorServer(JMXServiceURL address, Map env) throws IOException {
        this(address, env, (MBeanServer)null);
    }

    public JMXMPConnectorServer(JMXServiceURL address, Map env, MBeanServer mbs) throws IOException {
        super(JMXMPConnectorServer.completeEnv(address, env), mbs);
    }

    private static Map completeEnv(JMXServiceURL address, Map env) throws IOException {
        if (env != null && env.containsKey("jmx.remote.message.connection.server")) {
            return env;
        }
        if (address == null) {
            address = new JMXServiceURL("jmxmp", null, 0);
        }
        HashMap<String, SocketConnectionServer> newEnv = env == null ? new HashMap<String, SocketConnectionServer>() : new HashMap(env);
        newEnv.put("jmx.remote.message.connection.server", new SocketConnectionServer(address, newEnv));
        return newEnv;
    }
}

