/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.eesecurity;

import fish.payara.microprofile.jwtauth.eesecurity.SignedJWTCredential;
import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.enterprise.inject.spi.CDI;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JWTAuthenticationMechanism
implements HttpAuthenticationMechanism {
    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (httpMessageContext.isProtected()) {
            IdentityStoreHandler identityStoreHandler = (IdentityStoreHandler)CDI.current().select(IdentityStoreHandler.class, new Annotation[0]).get();
            SignedJWTCredential credential = this.getCredential(request);
            if (credential != null) {
                CredentialValidationResult result = identityStoreHandler.validate((Credential)credential);
                if (result.getStatus() == CredentialValidationResult.Status.VALID) {
                    httpMessageContext.getClientSubject().getPrincipals().add((Principal)result.getCallerPrincipal());
                }
                return httpMessageContext.notifyContainerAboutLogin(result);
            }
        }
        return httpMessageContext.doNothing();
    }

    private SignedJWTCredential getCredential(HttpServletRequest request) {
        String token;
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ") && (token = authorizationHeader.substring("Bearer ".length())) != null && !token.isEmpty()) {
            return new SignedJWTCredential(token);
        }
        return null;
    }
}

