/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.zendesk;

import fish.payara.appserver.zendesk.config.ZendeskSupportConfiguration;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="zendesk-support")
@RunLevel(value=10)
public class ZendeskSupportService
implements ConfigListener {
    private static final Logger LOGGER = Logger.getLogger(ZendeskSupportService.class.getCanonicalName());
    @Inject
    @Named(value="default-instance-name")
    @Optional
    ZendeskSupportConfiguration zendeskSupportConfiguration;
    @Inject
    Events events;
    @Inject
    ServiceLocator habitat;

    @PostConstruct
    void postConstruct() {
        this.zendeskSupportConfiguration = (ZendeskSupportConfiguration)this.habitat.getService(ZendeskSupportConfiguration.class, new Annotation[0]);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] pces) {
        for (PropertyChangeEvent pce : pces) {
            if (!pce.getPropertyName().equals("emailAddress")) continue;
            this.zendeskSupportConfiguration.setEmailAddress(pce.getNewValue().toString());
        }
        return null;
    }
}

