/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.zendesk.admin;

import com.sun.enterprise.util.StringUtils;
import fish.payara.appserver.zendesk.config.ZendeskSupportConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-domain-xml")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=ZendeskSupportConfiguration.class, opType=RestEndpoint.OpType.GET, path="get-domain-xml", description="Gets a copy of the full domain.xml")})
public class GetDomainXMLCommand
implements AdminCommand {
    @Inject
    ServerEnvironment se;

    public void execute(AdminCommandContext context) {
        File configFile = new File(this.se.getConfigDirPath().getAbsolutePath() + "/domain.xml");
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String all = "";
            String line = reader.readLine();
            while (line != null) {
                all = all + line;
                all = all + StringUtils.EOL;
                line = reader.readLine();
            }
            ActionReport actionReport = context.getActionReport();
            actionReport.appendMessage(all);
            HashMap<String, String> extraPropsMap = new HashMap<String, String>();
            extraPropsMap.put("domainxml", all);
            Properties extraProps = new Properties();
            extraProps.put("zendeskSupportConfiguration", extraPropsMap);
            actionReport.setExtraProperties(extraProps);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GetDomainXMLCommand.class.getName()).log(Level.SEVERE, "domain.xml not found");
        }
        catch (IOException ex) {
            Logger.getLogger(GetDomainXMLCommand.class.getName()).log(Level.SEVERE, "Error reading domain.xml");
        }
    }
}

