/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.zendesk.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.StringUtils;
import fish.payara.appserver.zendesk.ZendeskSupportService;
import fish.payara.appserver.zendesk.config.ZendeskSupportConfiguration;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="set-zendesk-support-configuration")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=ZendeskSupportConfiguration.class, opType=RestEndpoint.OpType.POST, path="set-zendesk-support-configuration", description="Sets the Zendesk Support Configuration")})
public class SetZendeskSupportConfigurationCommand
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Inject
    private ZendeskSupportService zendeskSupport;
    @Param(name="emailAddress", alias="emailaddress", optional=true)
    private String emailAddress;
    @Param(name="enabled", optional=true)
    private Boolean enabled;
    private final String target = "server-config";

    public void execute(AdminCommandContext acc) {
        Config config = this.targetUtil.getConfig("server-config");
        ActionReport actionReport = acc.getActionReport();
        ZendeskSupportConfiguration zendeskSupportConfiguration = (ZendeskSupportConfiguration)config.getExtensionByType(ZendeskSupportConfiguration.class);
        if (zendeskSupportConfiguration != null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ZendeskSupportConfiguration>(){

                    public Object run(ZendeskSupportConfiguration config) {
                        if (SetZendeskSupportConfigurationCommand.this.enabled != null) {
                            config.setEnabled(Boolean.toString(SetZendeskSupportConfigurationCommand.this.enabled));
                        }
                        if (StringUtils.ok((String)SetZendeskSupportConfigurationCommand.this.emailAddress)) {
                            config.setEmailAddress(SetZendeskSupportConfigurationCommand.this.emailAddress);
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)zendeskSupportConfiguration);
            }
            catch (TransactionFailure ex) {
                actionReport.failure(Logger.getLogger(SetZendeskSupportConfigurationCommand.class.getName()), "Failed to update configuration", (Throwable)ex);
            }
        }
    }
}

