/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.stuck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.admin.HealthCheckServiceConfigurer;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.configuration.StuckThreadsChecker;
import fish.payara.nucleus.healthcheck.stuck.StuckThreadsHealthCheck;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Deprecated
@Service(name="healthcheck-stuckthreads-configure")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.stuckthreads.configure")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=HealthCheckServiceConfiguration.class, opType=RestEndpoint.OpType.POST, path="healthcheck-stuckthreads-configure", description="Configures the Stuck Threads Checker")})
public class StuckThreadsConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="time", optional=true)
    @Min(value=1L, message="Time period must be 1 or more")
    private @Min(value=1L, message="Time period must be 1 or more") String time;
    @Param(name="unit", optional=true, acceptableValues="DAYS,HOURS,MICROSECONDS,MILLISECONDS,MINUTES,NANOSECONDS,SECONDS")
    private String unit;
    @Param(name="threshold", optional=true)
    @Min(value=1L, message="Threshold length must be 1 or more")
    private @Min(value=1L, message="Threshold length must be 1 or more") String threshold;
    @Param(name="thresholdUnit", optional=true, acceptableValues="DAYS,HOURS,MILLISECONDS,MINUTES,SECONDS")
    private String thresholdUnit;
    @Param(name="checkerName", optional=true)
    private String checkerName;
    @Param(name="target", optional=true, defaultValue="server-config")
    protected String target;
    @Inject
    ServerEnvironment server;

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        StuckThreadsHealthCheck service = (StuckThreadsHealthCheck)this.habitat.getService(StuckThreadsHealthCheck.class, new Annotation[0]);
        final ActionReport actionReport = context.getActionReport();
        if (service == null) {
            actionReport.appendMessage(strings.getLocalString("healthcheck.stuckthreads.configure.status.error", "Stuck Threads Checker Service could not be found"));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            HealthCheckServiceConfiguration healthCheckServiceConfiguration = (HealthCheckServiceConfiguration)config.getExtensionByType(HealthCheckServiceConfiguration.class);
            StuckThreadsChecker stuckThreadConfiguration = healthCheckServiceConfiguration.getCheckerByType(StuckThreadsChecker.class);
            if (stuckThreadConfiguration == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        StuckThreadsChecker checkerProxy = (StuckThreadsChecker)healthCheckServiceConfigurationProxy.createChild(StuckThreadsChecker.class);
                        StuckThreadsConfigurer.this.applyValues(checkerProxy);
                        healthCheckServiceConfigurationProxy.getCheckerList().add(checkerProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, (ConfigBeanProxy)healthCheckServiceConfiguration);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<StuckThreadsChecker>(){

                    public Object run(StuckThreadsChecker hoggingThreadConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        StuckThreadsConfigurer.this.applyValues(hoggingThreadConfigurationProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return hoggingThreadConfigurationProxy;
                    }
                }, (ConfigBeanProxy)stuckThreadConfiguration);
            }
            if (this.dynamic.booleanValue()) {
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        StuckThreadsChecker checkerByType = healthCheckServiceConfiguration.getCheckerByType(StuckThreadsChecker.class);
                        service.setOptions(service.constructOptions(checkerByType));
                        this.healthCheckService.registerCheck(checkerByType.getName(), service);
                        this.healthCheckService.reboot();
                    }
                } else {
                    StuckThreadsChecker checkerByType = healthCheckServiceConfiguration.getCheckerByType(StuckThreadsChecker.class);
                    service.setOptions(service.constructOptions(stuckThreadConfiguration));
                    this.healthCheckService.registerCheck(checkerByType.getName(), service);
                    this.healthCheckService.reboot();
                }
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void applyValues(StuckThreadsChecker checkerProxy) throws PropertyVetoException {
        if (this.enabled != null) {
            checkerProxy.setEnabled(this.enabled.toString());
        }
        if (this.checkerName != null) {
            checkerProxy.setName(this.checkerName);
        }
        if (this.time != null) {
            checkerProxy.setTime(this.time);
        }
        if (this.unit != null) {
            checkerProxy.setUnit(this.unit);
        }
        if (this.threshold != null) {
            checkerProxy.setThreshold(this.threshold);
        }
        if (this.thresholdUnit != null) {
            checkerProxy.setThresholdTimeUnit(this.thresholdUnit);
        }
    }
}

