/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck.checks;

import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.util.List;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class PayaraHealthCheck
implements HealthCheck {
    private String name;
    private BaseHealthCheck<?, ?> checker;

    public PayaraHealthCheck(String name, BaseHealthCheck<?, ?> checker) {
        this.name = name;
        this.checker = checker;
    }

    @Override
    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named(this.name);
        boolean status = true;
        this.checker.doCheck();
        List healthCheckResults = this.checker.getMostRecentResult().getEntries();
        if (healthCheckResults.isEmpty()) {
            responseBuilder.withData("Message", "No result to display");
            return responseBuilder.status(status).build();
        }
        for (HealthCheckResultEntry healthCheckResultEntry : healthCheckResults) {
            responseBuilder.withData("Message", healthCheckResultEntry.getMessage());
        }
        String healthStatus = this.checker.getMostRecentCumulativeStatus().name();
        if (!healthStatus.trim().isEmpty()) {
            responseBuilder.withData("HealthCheckStatus", healthStatus);
            if (healthStatus.equals("CRITICAL") || healthStatus.equals("CHECK_ERROR")) {
                status = false;
            }
        }
        return responseBuilder.status(status).build();
    }
}

