/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.Extension;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.weld.BeanDeploymentArchiveImpl;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.InjectionServicesImpl;
import org.glassfish.weld.services.ResourceInjectionServicesImpl;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.helpers.MetadataImpl;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;

public class DeploymentImpl
implements CDI11Deployment {
    private List<RootBeanDeploymentArchive> rarRootBdas;
    private List<RootBeanDeploymentArchive> ejbRootBdas;
    private List<RootBeanDeploymentArchive> warRootBdas;
    private List<RootBeanDeploymentArchive> libJarRootBdas = null;
    private List<BeanDeploymentArchive> beanDeploymentArchives = new ArrayList<BeanDeploymentArchive>();
    private DeploymentContext context;
    private Map<String, BeanDeploymentArchive> idToBeanDeploymentArchive = new HashMap<String, BeanDeploymentArchive>();
    private SimpleServiceRegistry simpleServiceRegistry = null;
    private Logger logger = CDILoggerInfo.getLogger();
    private Map<ClassLoader, BeanDeploymentArchive> extensionBDAMap = new HashMap<ClassLoader, BeanDeploymentArchive>();
    private Iterable<Metadata<Extension>> extensions;
    private List<Metadata<Extension>> dynamicExtensions = new ArrayList<Metadata<Extension>>();
    private Collection<EjbDescriptor> deployedEjbs = new LinkedList<EjbDescriptor>();
    private ArchiveFactory archiveFactory;
    private boolean earContextAppLibBdasProcessed = false;
    private String appName;
    private String contextId;
    final InjectionManager injectionManager;

    public DeploymentImpl(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, ArchiveFactory archiveFactory, String moduleName, InjectionManager injectionManager) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00018", new Object[]{archive.getName()});
        }
        this.archiveFactory = archiveFactory;
        this.context = context;
        this.injectionManager = injectionManager;
        this.libJarRootBdas = this.scanForLibJars(archive, ejbs, context);
        if (this.libJarRootBdas != null && !this.libJarRootBdas.isEmpty()) {
            return;
        }
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        this.appName = holder != null && holder.app != null ? holder.app.getAppName() : (moduleName != null ? moduleName : "CDIApp");
        this.contextId = moduleName != null ? moduleName : archive.getName();
        this.createModuleBda(archive, ejbs, context, this.contextId);
    }

    private void addBeanDeploymentArchives(RootBeanDeploymentArchive bda) {
        WeldUtils.BDAType moduleBDAType = bda.getModuleBDAType();
        if (moduleBDAType.equals((Object)WeldUtils.BDAType.WAR)) {
            if (this.warRootBdas == null) {
                this.warRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            this.warRootBdas.add(bda);
        } else if (moduleBDAType.equals((Object)WeldUtils.BDAType.JAR)) {
            if (this.ejbRootBdas == null) {
                this.ejbRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            this.ejbRootBdas.add(bda);
        } else if (moduleBDAType.equals((Object)WeldUtils.BDAType.RAR)) {
            if (this.rarRootBdas == null) {
                this.rarRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            this.rarRootBdas.add(bda);
        }
    }

    public void scanArchive(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, String moduleName) {
        if (this.libJarRootBdas == null) {
            this.libJarRootBdas = this.scanForLibJars(archive, ejbs, context);
            if (this.libJarRootBdas != null && !this.libJarRootBdas.isEmpty()) {
                return;
            }
        }
        this.context = context;
        this.createModuleBda(archive, ejbs, context, moduleName);
    }

    public void buildDeploymentGraph() {
        BeanDeploymentArchive rarModuleBda;
        BeanDeploymentArchive libJarModuleBda;
        if (this.ejbRootBdas != null) {
            for (RootBeanDeploymentArchive ejbRootBda : this.ejbRootBdas) {
                int idx;
                BeanDeploymentArchive ejbModuleBda = ejbRootBda.getModuleBda();
                boolean modifiedArchive = false;
                for (RootBeanDeploymentArchive otherEjbRootBda : this.ejbRootBdas) {
                    BeanDeploymentArchive otherEjbModuleBda = otherEjbRootBda.getModuleBda();
                    if (otherEjbModuleBda.getId().equals(ejbModuleBda.getId())) continue;
                    ejbRootBda.getBeanDeploymentArchives().add(otherEjbRootBda);
                    ejbRootBda.getBeanDeploymentArchives().add(otherEjbModuleBda);
                    ejbModuleBda.getBeanDeploymentArchives().add(otherEjbModuleBda);
                    modifiedArchive = true;
                }
                if (this.libJarRootBdas != null) {
                    for (RootBeanDeploymentArchive libJarRootBda : this.libJarRootBdas) {
                        libJarModuleBda = libJarRootBda.getModuleBda();
                        ejbRootBda.getBeanDeploymentArchives().add(libJarRootBda);
                        ejbRootBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(libJarRootBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        modifiedArchive = true;
                    }
                }
                if (this.rarRootBdas != null) {
                    for (RootBeanDeploymentArchive rarRootBda : this.rarRootBdas) {
                        rarModuleBda = rarRootBda.getModuleBda();
                        ejbRootBda.getBeanDeploymentArchives().add(rarRootBda);
                        ejbRootBda.getBeanDeploymentArchives().add(rarModuleBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(rarRootBda);
                        ejbModuleBda.getBeanDeploymentArchives().add(rarModuleBda);
                        modifiedArchive = true;
                    }
                }
                if (!modifiedArchive || (idx = this.getBeanDeploymentArchives().indexOf(ejbModuleBda)) < 0) continue;
                this.getBeanDeploymentArchives().remove(idx);
                this.getBeanDeploymentArchives().add(ejbModuleBda);
            }
        }
        if (this.warRootBdas != null) {
            ListIterator<RootBeanDeploymentArchive> warIter = this.warRootBdas.listIterator();
            boolean modifiedArchive = false;
            while (warIter.hasNext()) {
                RootBeanDeploymentArchive warRootBda = warIter.next();
                BeanDeploymentArchive warModuleBda = warRootBda.getModuleBda();
                if (this.ejbRootBdas != null) {
                    for (RootBeanDeploymentArchive ejbRootBda : this.ejbRootBdas) {
                        BeanDeploymentArchive ejbModuleBda = ejbRootBda.getModuleBda();
                        warRootBda.getBeanDeploymentArchives().add(ejbRootBda);
                        warRootBda.getBeanDeploymentArchives().add(ejbModuleBda);
                        warModuleBda.getBeanDeploymentArchives().add(ejbRootBda);
                        warModuleBda.getBeanDeploymentArchives().add(ejbModuleBda);
                        for (BeanDeploymentArchive oneBda : warModuleBda.getBeanDeploymentArchives()) {
                            oneBda.getBeanDeploymentArchives().add(ejbRootBda);
                            oneBda.getBeanDeploymentArchives().add(ejbModuleBda);
                        }
                        modifiedArchive = true;
                    }
                }
                if (this.libJarRootBdas != null) {
                    for (RootBeanDeploymentArchive libJarRootBda : this.libJarRootBdas) {
                        libJarModuleBda = libJarRootBda.getModuleBda();
                        warRootBda.getBeanDeploymentArchives().add(libJarRootBda);
                        warRootBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        warModuleBda.getBeanDeploymentArchives().add(libJarRootBda);
                        warModuleBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        for (BeanDeploymentArchive oneBda : warModuleBda.getBeanDeploymentArchives()) {
                            oneBda.getBeanDeploymentArchives().add(libJarRootBda);
                            oneBda.getBeanDeploymentArchives().add(libJarModuleBda);
                        }
                        modifiedArchive = true;
                    }
                }
                if (this.rarRootBdas != null) {
                    for (RootBeanDeploymentArchive rarRootBda : this.rarRootBdas) {
                        rarModuleBda = rarRootBda.getModuleBda();
                        warRootBda.getBeanDeploymentArchives().add(rarRootBda);
                        warRootBda.getBeanDeploymentArchives().add(rarModuleBda);
                        warModuleBda.getBeanDeploymentArchives().add(rarRootBda);
                        warModuleBda.getBeanDeploymentArchives().add(rarModuleBda);
                        for (BeanDeploymentArchive oneBda : warModuleBda.getBeanDeploymentArchives()) {
                            oneBda.getBeanDeploymentArchives().add(rarRootBda);
                            oneBda.getBeanDeploymentArchives().add(rarModuleBda);
                        }
                        modifiedArchive = true;
                    }
                }
                if (!modifiedArchive) continue;
                int idx = this.getBeanDeploymentArchives().indexOf(warModuleBda);
                if (idx >= 0) {
                    this.getBeanDeploymentArchives().remove(idx);
                    this.getBeanDeploymentArchives().add(warModuleBda);
                }
                modifiedArchive = false;
            }
        }
        this.addDependentBdas();
    }

    private void addDependentBdas() {
        HashSet<BeanDeploymentArchive> additionalBdas = new HashSet<BeanDeploymentArchive>();
        for (BeanDeploymentArchive oneBda : this.beanDeploymentArchives) {
            BeanDeploymentArchiveImpl beanDeploymentArchiveImpl = (BeanDeploymentArchiveImpl)oneBda;
            Collection<BeanDeploymentArchive> subBdas = beanDeploymentArchiveImpl.getBeanDeploymentArchives();
            for (BeanDeploymentArchive subBda : subBdas) {
                if (subBda.getBeanClasses().isEmpty()) continue;
                additionalBdas.add(subBda);
            }
        }
        for (BeanDeploymentArchive oneBda : additionalBdas) {
            if (this.beanDeploymentArchives.contains(oneBda)) continue;
            this.beanDeploymentArchives.add(oneBda);
        }
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00019", new Object[]{this.beanDeploymentArchives});
        }
        return this.beanDeploymentArchives;
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00020", new Object[]{beanClass});
        }
        Collection beanDeploymentArchives = this.getBeanDeploymentArchives();
        ListIterator lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = (BeanDeploymentArchive)lIter.next();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00021", new Object[]{beanClass, bda.getId()});
            }
            if (((BeanDeploymentArchiveImpl)bda).getModuleBeanClasses().contains(beanClass.getName())) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00022", new Object[]{beanClass.getName(), bda});
                }
                return bda;
            }
            if (bda.getBeanDeploymentArchives().isEmpty()) continue;
            for (BeanDeploymentArchive subBda : bda.getBeanDeploymentArchives()) {
                boolean match;
                Collection<String> moduleBeanClassNames = ((BeanDeploymentArchiveImpl)subBda).getModuleBeanClasses();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00023", new Object[]{beanClass, subBda.getId()});
                }
                if (!(match = moduleBeanClassNames.contains(beanClass.getName()))) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "AS-CDI-00022", new Object[]{beanClass.getName(), subBda});
                }
                return subBda;
            }
        }
        BeanDeploymentArchive extensionBDA = this.extensionBDAMap.get(beanClass.getClassLoader());
        if (extensionBDA != null) {
            return extensionBDA;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "AS-CDI-00024", new Object[]{beanClass});
        }
        ArrayList beanClasses = new ArrayList();
        CopyOnWriteArrayList<URL> beanXMLUrls = new CopyOnWriteArrayList<URL>();
        HashSet<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
        beanClasses.add(beanClass);
        BeanDeploymentArchiveImpl newBda = new BeanDeploymentArchiveImpl(beanClass.getName(), beanClasses, beanXMLUrls, ejbs, this.context);
        newBda.getServices().add(InjectionServices.class, (Service)new InjectionServicesImpl(this.injectionManager, DOLUtils.getCurrentBundleForContext((DeploymentContext)this.context), this));
        newBda.getServices().add(ResourceInjectionServices.class, (Service)new ResourceInjectionServicesImpl());
        BeansXml beansXml = newBda.getBeansXml();
        if (beansXml == null || !beansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00025", new Object[0]);
            }
            lIter = beanDeploymentArchives.listIterator();
            while (lIter.hasNext()) {
                BeanDeploymentArchive bda = (BeanDeploymentArchive)lIter.next();
                bda.getBeanDeploymentArchives().add(newBda);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "AS-CDI-00026", new Object[]{beanClass, newBda});
            }
            beanDeploymentArchives.add(newBda);
            this.idToBeanDeploymentArchive.put(newBda.getId(), newBda);
            this.extensionBDAMap.put(beanClass.getClassLoader(), newBda);
            return newBda;
        }
        return null;
    }

    public ServiceRegistry getServices() {
        if (this.simpleServiceRegistry == null) {
            this.simpleServiceRegistry = new SimpleServiceRegistry();
        }
        return this.simpleServiceRegistry;
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        Collection bdas = this.getBeanDeploymentArchives();
        ArrayList<Metadata<Extension>> extnList = new ArrayList<Metadata<Extension>>();
        HashSet<ClassLoader> scannedClassLoaders = new HashSet<ClassLoader>();
        HashMap loadedExtensions = new HashMap();
        for (BeanDeploymentArchive bda : bdas) {
            ClassLoader moduleClassLoader;
            if (bda instanceof RootBeanDeploymentArchive || scannedClassLoaders.contains(moduleClassLoader = ((BeanDeploymentArchiveImpl)bda).getModuleClassLoaderForBDA())) continue;
            scannedClassLoaders.add(moduleClassLoader);
            this.extensions = ((WeldBootstrap)this.context.getTransientAppMetaData("org.glassfish.weld.WeldBootstrap", WeldBootstrap.class)).loadExtensions(moduleClassLoader);
            if (this.extensions == null) continue;
            for (Metadata<Extension> bdaExtn : this.extensions) {
                if (loadedExtensions.get(((Extension)bdaExtn.getValue()).getClass()) != null) continue;
                extnList.add(bdaExtn);
                loadedExtensions.put(((Extension)bdaExtn.getValue()).getClass(), bdaExtn);
            }
        }
        Iterable snifferExtensions = (Iterable)this.context.getTransientAppMetaData("org.glassfish.weld.sniffers", Iterable.class);
        for (Supplier extensionCreator : snifferExtensions) {
            Extension extension = (Extension)extensionCreator.get();
            Class<?> extensionClass = extension.getClass();
            MetadataImpl extensionMetadata = new MetadataImpl((Object)extension, extensionClass.getName());
            extnList.add((Metadata<Extension>)extensionMetadata);
        }
        extnList.addAll(this.dynamicExtensions);
        this.extensions = extnList;
        return extnList;
    }

    public boolean addDynamicExtension(Metadata<Extension> extension) {
        return this.dynamicExtensions.add(extension);
    }

    public boolean removeDynamicExtension(Metadata<Extension> extension) {
        return this.dynamicExtensions.remove(extension);
    }

    public void clearDynamicExtensions() {
        this.dynamicExtensions.clear();
    }

    public String toString() {
        StringBuilder valBuff = new StringBuilder();
        Collection beanDeploymentArchives = this.getBeanDeploymentArchives();
        ListIterator lIter = beanDeploymentArchives.listIterator();
        while (lIter.hasNext()) {
            BeanDeploymentArchive bda = (BeanDeploymentArchive)lIter.next();
            valBuff.append(bda.toString());
        }
        return valBuff.toString();
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForArchive(String archiveId) {
        return this.idToBeanDeploymentArchive.get(archiveId);
    }

    public void cleanup() {
        if (this.ejbRootBdas != null) {
            this.ejbRootBdas.clear();
        }
        if (this.warRootBdas != null) {
            this.warRootBdas.clear();
        }
        if (this.libJarRootBdas != null) {
            this.libJarRootBdas.clear();
        }
        if (this.rarRootBdas != null) {
            this.rarRootBdas.clear();
        }
        if (this.idToBeanDeploymentArchive != null) {
            this.idToBeanDeploymentArchive.clear();
        }
    }

    private List<RootBeanDeploymentArchive> scanForLibJars(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context) {
        String libDir;
        ArrayList<ReadableArchive> libJars = null;
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        if (holder != null && holder.app != null && (libDir = holder.app.getLibraryDirectory()) != null && !libDir.isEmpty()) {
            Enumeration entries = archive.entries(libDir);
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!DOLUtils.isScanningAllowed((Application)holder.app, (String)entryName) || !entryName.endsWith(".jar") || entryName.indexOf(47, libDir.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    if (jarInLib == null || !jarInLib.exists("META-INF/beans.xml") && !WeldUtils.isImplicitBeanArchive((DeploymentContext)context, (ReadableArchive)jarInLib)) continue;
                    if (libJars == null) {
                        libJars = new ArrayList<ReadableArchive>();
                    }
                    libJars.add(jarInLib);
                }
                catch (IOException e) {
                    this.logger.log(Level.FINE, "AS-CDI-00027", new Object[]{e});
                }
            }
        }
        if (libJars != null) {
            libDir = holder.app.getLibraryDirectory();
            for (ReadableArchive libJarArchive : libJars) {
                this.createLibJarBda(libJarArchive, ejbs, libDir);
            }
        }
        return this.libJarRootBdas;
    }

    private void createLibJarBda(ReadableArchive libJarArchive, Collection<EjbDescriptor> ejbs, String libDir) {
        RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(libJarArchive, ejbs, this.context, libDir + '/' + libJarArchive.getName());
        this.createLibJarBda(rootBda);
    }

    private void createLibJarBda(RootBeanDeploymentArchive rootLibBda) {
        BeanDeploymentArchive libModuleBda = rootLibBda.getModuleBda();
        BeansXml moduleBeansXml = libModuleBda.getBeansXml();
        if (moduleBeansXml == null || !moduleBeansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            this.addBdaToDeploymentBdas(rootLibBda);
            this.addBdaToDeploymentBdas(libModuleBda);
            if (this.libJarRootBdas == null) {
                this.libJarRootBdas = new ArrayList<RootBeanDeploymentArchive>();
            }
            for (RootBeanDeploymentArchive existingLibJarRootBda : this.libJarRootBdas) {
                rootLibBda.getBeanDeploymentArchives().add(existingLibJarRootBda);
                rootLibBda.getBeanDeploymentArchives().add(existingLibJarRootBda.getModuleBda());
                rootLibBda.getModuleBda().getBeanDeploymentArchives().add(existingLibJarRootBda);
                rootLibBda.getModuleBda().getBeanDeploymentArchives().add(existingLibJarRootBda.getModuleBda());
                existingLibJarRootBda.getBeanDeploymentArchives().add(rootLibBda);
                existingLibJarRootBda.getBeanDeploymentArchives().add(rootLibBda.getModuleBda());
                existingLibJarRootBda.getModuleBda().getBeanDeploymentArchives().add(rootLibBda);
                existingLibJarRootBda.getModuleBda().getBeanDeploymentArchives().add(rootLibBda.getModuleBda());
            }
            this.libJarRootBdas.add(rootLibBda);
        }
    }

    private void addBdaToDeploymentBdas(BeanDeploymentArchive bda) {
        if (!this.beanDeploymentArchives.contains(bda)) {
            this.beanDeploymentArchives.add(bda);
            this.idToBeanDeploymentArchive.put(bda.getId(), bda);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBdasForAppLibs(ReadableArchive archive, DeploymentContext context) {
        ArrayList<RootBeanDeploymentArchive> libBdas;
        block12: {
            libBdas = new ArrayList<RootBeanDeploymentArchive>();
            try {
                List appLibs = context.getAppLibs();
                Set installedLibraries = InstalledLibrariesResolver.getInstalledLibraries((ReadableArchive)archive);
                if (appLibs == null || appLibs.isEmpty() || installedLibraries == null || installedLibraries.isEmpty()) break block12;
                block9: for (URI oneAppLib : appLibs) {
                    for (String oneInstalledLibrary : installedLibraries) {
                        if (!oneAppLib.getPath().endsWith(oneInstalledLibrary)) continue;
                        ReadableArchive libArchive = null;
                        try {
                            libArchive = this.archiveFactory.openArchive(oneAppLib);
                            if (!libArchive.exists("META-INF/beans.xml")) continue block9;
                            String bdaId = archive.getName() + "_" + libArchive.getName();
                            RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(libArchive, Collections.emptyList(), context, bdaId);
                            libBdas.add(rootBda);
                            continue block9;
                        }
                        finally {
                            if (libArchive == null) continue block9;
                            try {
                                libArchive.close();
                            }
                            catch (Exception exception) {}
                            continue block9;
                        }
                    }
                }
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        for (RootBeanDeploymentArchive oneBda : libBdas) {
            this.createLibJarBda(oneBda);
        }
    }

    protected void addDeployedEjbs(Collection<EjbDescriptor> ejbs) {
        if (ejbs != null) {
            this.deployedEjbs.addAll(ejbs);
        }
    }

    public Collection<EjbDescriptor> getDeployedEjbs() {
        return this.deployedEjbs;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        for (BeanDeploymentArchive oneBda : this.beanDeploymentArchives) {
            BeanDeploymentArchiveImpl beanDeploymentArchiveImpl = (BeanDeploymentArchiveImpl)oneBda;
            if (!beanDeploymentArchiveImpl.getBeanClassObjects().contains(beanClass)) continue;
            return oneBda;
        }
        ClassLoader classLoader = beanClass.getClassLoader();
        RootBeanDeploymentArchive rootBda = this.findRootBda(classLoader, this.ejbRootBdas);
        if (rootBda == null && (rootBda = this.findRootBda(classLoader, this.warRootBdas)) == null && (rootBda = this.findRootBda(classLoader, this.libJarRootBdas)) == null) {
            rootBda = this.findRootBda(classLoader, this.rarRootBdas);
        }
        return rootBda;
    }

    private RootBeanDeploymentArchive findRootBda(ClassLoader classLoader, List<RootBeanDeploymentArchive> rootBdas) {
        if (rootBdas == null || classLoader == null) {
            return null;
        }
        for (RootBeanDeploymentArchive oneRootBda : rootBdas) {
            if (!classLoader.equals(oneRootBda.getModuleClassLoaderForBDA())) continue;
            return oneRootBda;
        }
        return null;
    }

    private void createModuleBda(ReadableArchive archive, Collection<EjbDescriptor> ejbs, DeploymentContext context, String moduleName) {
        DeploymentContextImpl deploymentContext;
        ExtendedDeploymentContext parentContext;
        RootBeanDeploymentArchive rootBda = new RootBeanDeploymentArchive(archive, ejbs, context, moduleName);
        BeanDeploymentArchive moduleBda = rootBda.getModuleBda();
        BeansXml moduleBeansXml = moduleBda.getBeansXml();
        if (moduleBeansXml == null || !moduleBeansXml.getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
            this.addBdaToDeploymentBdas(rootBda);
            this.addBdaToDeploymentBdas(moduleBda);
            this.addBeanDeploymentArchives(rootBda);
        }
        if (!this.earContextAppLibBdasProcessed && context instanceof DeploymentContextImpl && (parentContext = (deploymentContext = (DeploymentContextImpl)context).getParentContext()) != null) {
            this.processBdasForAppLibs(parentContext.getSource(), (DeploymentContext)parentContext);
            parentContext.getSource();
            this.earContextAppLibBdasProcessed = true;
        }
        this.processBdasForAppLibs(archive, context);
    }

    public Iterator<RootBeanDeploymentArchive> getLibJarRootBdas() {
        if (this.libJarRootBdas == null) {
            return null;
        }
        return this.libJarRootBdas.iterator();
    }

    public Iterator<RootBeanDeploymentArchive> getRarRootBdas() {
        if (this.rarRootBdas == null) {
            return null;
        }
        return this.rarRootBdas.iterator();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getContextId() {
        return this.contextId;
    }
}

