/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import java.lang.annotation.Annotation;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.glassfish.hk2.api.ServiceLocator;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionServicesImpl
implements TransactionServices {
    private JavaEETransactionManager transactionManager;

    public TransactionServicesImpl(ServiceLocator services) {
        this.transactionManager = (JavaEETransactionManager)services.getService(JavaEETransactionManager.class, new Annotation[0]);
        if (this.transactionManager == null) {
            throw new RuntimeException("Unable to retrieve transaction mgr.");
        }
    }

    public boolean isTransactionActive() {
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    return true;
                }
            }
            return false;
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to determine transaction status", e);
        }
    }

    public void registerSynchronization(Synchronization observer) {
        try {
            this.transactionManager.registerSynchronization(observer);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register synchronization " + observer + " for current transaction", e);
        }
    }

    public UserTransaction getUserTransaction() {
        try {
            return (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            return null;
        }
    }

    public void cleanup() {
    }
}

