/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import fish.payara.monitoring.collect.MonitoringDataCollection;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.admin.monitor.jvm.JVMClassLoadingStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMCompilationStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMGCStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMMemoryStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMOSStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMRuntimeStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadInfoStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadSystemStatsProvider;
import org.glassfish.admin.monitor.jvm.ServerRuntimeStatsProvider;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=20, mode=0)
public class JVMStatsProviderBootstrap
implements PostConstruct,
MonitoringDataSource {
    private final ServerRuntimeStatsProvider sRuntimeStatsProvider = new ServerRuntimeStatsProvider();
    private final JVMClassLoadingStatsProvider clStatsProvider = new JVMClassLoadingStatsProvider();
    private final JVMCompilationStatsProvider compileStatsProvider = new JVMCompilationStatsProvider();
    private final JVMMemoryStatsProvider memoryStatsProvider = new JVMMemoryStatsProvider();
    private final JVMOSStatsProvider osStatsProvider = new JVMOSStatsProvider();
    private final JVMRuntimeStatsProvider runtimeStatsProvider = new JVMRuntimeStatsProvider();
    private final JVMThreadSystemStatsProvider threadSysStatsProvider = new JVMThreadSystemStatsProvider();
    private final List<JVMGCStatsProvider> jvmStatsProviderList = new ArrayList<JVMGCStatsProvider>();
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    public static final String JVM = "jvm";

    public void postConstruct() {
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"", (Object)this.sRuntimeStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/class-loading-system", (Object)this.clStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/compilation-system", (Object)this.compileStatsProvider, (String)"LOW");
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            JVMGCStatsProvider jvmStatsProvider = new JVMGCStatsProvider(gc.getName());
            this.jvmStatsProviderList.add(jvmStatsProvider);
            StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)("jvm/garbage-collectors/" + gc.getName()), (Object)jvmStatsProvider, (String)"LOW");
        }
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/memory", (Object)this.memoryStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/operating-system", (Object)this.osStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/runtime", (Object)this.runtimeStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/thread-system", (Object)this.threadSysStatsProvider, (String)"LOW");
        for (ThreadInfo t : this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), 5)) {
            if (t == null) continue;
            JVMThreadInfoStatsProvider threadInfoStatsProvider = new JVMThreadInfoStatsProvider(t);
            StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)("jvm/thread-system/thread-" + t.getThreadId()), (Object)threadInfoStatsProvider, (String)"HIGH");
        }
    }

    public void collect(MonitoringDataCollector collector) {
        MonitoringDataCollector jvm = collector.in((CharSequence)JVM);
        jvm.collectObject((Object)this.sRuntimeStatsProvider, MonitoringDataCollection::collectObject).collectObject((Object)this.clStatsProvider, MonitoringDataCollection::collectObject).collectObject((Object)this.compileStatsProvider, MonitoringDataCollection::collectObject).collectObject((Object)this.memoryStatsProvider, MonitoringDataCollection::collectObject).collectObject((Object)this.osStatsProvider, MonitoringDataCollection::collectObject).collectObject((Object)this.runtimeStatsProvider, MonitoringDataCollection::collectObject).collectObject((Object)this.threadSysStatsProvider, MonitoringDataCollection::collectObject);
        for (JVMGCStatsProvider gc : this.jvmStatsProviderList) {
            jvm.group((CharSequence)gc.getGcName()).collectObject((Object)gc, MonitoringDataCollection::collectObject);
        }
    }

    static {
        MonitoringDataCollection.register(CountStatistic.class, (collector, count) -> collector.collect((CharSequence)count.getName(), count.getCount()));
    }
}

