/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.report.PropsFileActionReporter;
import com.sun.enterprise.config.modularity.GetSetModularityHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.MonitoringReporter;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.Property;

@Service(name="get")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get", description="Get")})
public class GetCommand
extends V2DottedNameSupport
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    @Inject
    private MonitoringReporter mr;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private Target targetService;
    @Inject
    private ServiceLocator habitat;
    @Param(optional=true, defaultValue="false", shortName="m")
    private Boolean monitor;
    @Param(optional=true, defaultValue="false", shortName="c")
    private Boolean aggregateDataOnly;
    @Param(primary=true)
    private String pattern;
    @Inject
    @Optional
    private MonitoringRuntimeDataRegistry mrdr;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetCommand.class);
    private ActionReport report;
    private List<Map.Entry> matchingNodesSorted;
    private String prefix;
    @Inject
    @Optional
    GetSetModularityHelper modularityHelper;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        if (this.monitor.booleanValue()) {
            return this.preAuthorizationForMonitoring(context);
        }
        return this.preAuthorizationForNonMonitoring(context);
    }

    private boolean preAuthorizationForMonitoring(AdminCommandContext context) {
        this.mr.prepareGet(context, this.pattern, this.aggregateDataOnly);
        return true;
    }

    private boolean preAuthorizationForNonMonitoring(AdminCommandContext context) {
        this.report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)this.report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.matchingNodesSorted = this.findSortedMatchingNodes();
        return this.matchingNodesSorted != null;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        if (this.monitor.booleanValue()) {
            return this.mr.getAccessChecksForGet();
        }
        return this.getAccessChecksForNonMonitoring();
    }

    private Collection<? extends AccessRequired.AccessCheck> getAccessChecksForNonMonitoring() {
        ArrayList accessChecks = new ArrayList();
        for (Map.Entry entry : this.matchingNodesSorted) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromDom((Dom)entry.getKey()), "read"));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        if (this.monitor.booleanValue()) {
            this.getMonitorAttributes(context);
            return;
        }
        boolean foundMatch = false;
        for (Map.Entry node : this.matchingNodesSorted) {
            if (Property.class.getName().equals(((Dom)node.getKey()).model.targetTypeName)) {
                if (!this.matches((String)node.getValue(), this.pattern)) continue;
                ActionReport.MessagePart part = this.report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(this.prefix + (String)node.getValue() + "=" + ((Dom)node.getKey()).attribute("value"));
                foundMatch = true;
                continue;
            }
            Map<String, String> attributes = this.getNodeAttributes((Dom)node.getKey(), this.pattern);
            TreeMap<String, String> attributesSorted = new TreeMap<String, String>(attributes);
            for (Map.Entry<String, String> name : attributesSorted.entrySet()) {
                String finalDottedName = (String)node.getValue() + "." + name.getKey();
                if (!this.matches(finalDottedName, this.pattern)) continue;
                ActionReport.MessagePart part = this.report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(this.prefix + (String)node.getValue() + "." + name.getKey() + "=" + name.getValue());
                foundMatch = true;
            }
        }
        if (!foundMatch) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(localStrings.getLocalString("admin.get.path.notfound", "Dotted name path {0} not found.", new Object[]{this.prefix + this.pattern}));
        }
    }

    private void getMonitorAttributes(AdminCommandContext ctxt) {
        Logger l = KernelLoggerInfo.getLogger();
        if (l.isLoggable(Level.FINE)) {
            l.log(Level.FINE, "Get Command: {0}", this.mr.toString());
        }
        this.mr.execute();
    }

    private List<Map.Entry> findSortedMatchingNodes() {
        if (!this.monitor.booleanValue() && this.modularityHelper != null) {
            this.modularityHelper.getLocationForDottedName(this.pattern);
        }
        if (this.pattern.contains(".log-service")) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(localStrings.getLocalString("admin.get.invalid.logservice.command", "For getting log levels/attributes use list-log-levels/list-log-attributes command."));
            return null;
        }
        if (!(this.pattern.equals("*") || this.pattern.lastIndexOf(".") != -1 && this.pattern.lastIndexOf(".") != this.pattern.length() - 1)) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(localStrings.getLocalString("missing.dotted.name", "Missing expected dotted name part"));
            return null;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        this.prefix = "";
        if (!this.pattern.startsWith(parentNodes[0].relativeName)) {
            this.prefix = this.pattern.substring(0, this.pattern.indexOf(parentNodes[0].relativeName));
            this.pattern = parentNodes[0].relativeName;
        } else {
            this.pattern = parentNodes[0].relativeName;
        }
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
            if (!parentNode.name.equals("")) continue;
            dottedNames.put(parentNode.node, "domain");
        }
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        if (matchingNodes.isEmpty()) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(localStrings.getLocalString("admin.get.path.notfound", "Dotted name path {0} not found.", new Object[]{this.prefix + this.pattern}));
            return null;
        }
        List<Map.Entry> result = this.sortNodesByDottedName(matchingNodes);
        result = this.applyOverrideRules(result);
        return result;
    }
}

