/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.glassfish.bootstrap.StartupContextUtil;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.process.ProcessUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="__locations")
@Singleton
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="locations.command")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="locations", description="Location", useForAuthorization=true)})
public class LocationsCommand
implements AdminCommand {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    private UnprocessedConfigListener ucl;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(this.env.getInstanceRoot().getAbsolutePath().replace('\\', '/'));
        ActionReport.MessagePart mp = report.getTopMessagePart();
        mp.addProperty("Base-Root", StartupContextUtil.getInstallRoot((StartupContext)this.env.getStartupContext()).getAbsolutePath());
        mp.addProperty("Domain-Root", this.env.getInstanceRoot().getAbsolutePath());
        mp.addProperty("Instance-Root", this.env.getInstanceRoot().getAbsolutePath());
        mp.addProperty("Config-Dir", this.env.getConfigDirPath().getAbsolutePath());
        mp.addProperty("Uptime", "" + this.getUptime());
        mp.addProperty("Pid", "" + ProcessUtils.getPid());
        mp.addProperty("Restart-Required", "" + this.ucl.serverRequiresRestart());
    }

    private long getUptime() {
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        long totalTime_ms = -1L;
        if (mxbean != null) {
            totalTime_ms = mxbean.getUptime();
        }
        if (totalTime_ms <= 0L) {
            long start = this.env.getStartupContext().getCreationTime();
            totalTime_ms = System.currentTimeMillis() - start;
        }
        return totalTime_ms;
    }
}

