/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.admin.progress.ProgressStatusClient;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.Job;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-jobs")
@PerLookup
@I18n(value="list-jobs")
public class ListJobsCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private ActionReport report;
    private static final String DEFAULT_USER_STRING = "-";
    @Inject
    private JobManagerService jobManagerService;
    private final Collection<AccessRequired.AccessCheck<JobInfo>> jobAccessChecks = new ArrayList<AccessRequired.AccessCheck<JobInfo>>();
    private final String JOBS_FILE = "jobs.xml";
    @Param(optional=true, primary=true)
    String jobID;
    @Inject
    private ServerEnvironment serverEnvironment;
    protected static final String TITLE_NAME = "NAME";
    protected static final String TITLE_JOBID = "JOB ID";
    protected static final String TITLE_TIME = "TIME";
    protected static final String TITLE_STATE = "STATE";
    protected static final String TITLE_EXITCODE = "EXIT CODE";
    protected static final String TITLE_USER = "USER";
    protected static final String TITLE_NONE = "Nothing to list.";
    public static final String NAME = "jobName";
    public static final String ID = "jobId";
    public static final String DATE = "executionDate";
    public static final String CODE = "exitCode";
    public static final String USER = "user";
    public static final String STATE = "jobState";
    public static final String MESSAGE = "message";
    public static final String COMPLETION_DATE = "completionDate";
    private static final StringManager localStrings = StringManager.getManager(ListJobsCommand.class);

    protected JobInfos getCompletedJobs() {
        return this.jobManagerService.getCompletedJobs(this.jobManagerService.getJobsFile());
    }

    protected JobInfo getCompletedJobForId(String jobID) {
        return this.jobManagerService.getCompletedJobForId(jobID);
    }

    protected boolean isSingleJobOK(Job singleJob) {
        return singleJob != null;
    }

    protected boolean isJobEligible(Job job) {
        return !ListJobsCommand.skipJob(job.getName()) && this.checkScope(job);
    }

    protected boolean checkScope(Job job) {
        return job.getScope() == null;
    }

    private List<JobInfo> chooseJobs() {
        ArrayList<JobInfo> jobsToReport = new ArrayList<JobInfo>();
        if (this.jobID != null) {
            Job oneJob = this.jobManagerService.get(this.jobID);
            JobInfo info = null;
            if (this.isSingleJobOK(oneJob)) {
                String message;
                List<String> userList = oneJob.getSubjectUsernames();
                ActionReport actionReport = oneJob.getActionReport();
                String string = message = actionReport == null ? "" : actionReport.getMessage();
                if (!StringUtils.ok((String)message)) {
                    message = ProgressStatusClient.composeMessageForPrint((CommandProgress)oneJob.getCommandProgress());
                }
                String exitCode = actionReport == null ? "" : actionReport.getActionExitCode().name();
                info = new JobInfo(oneJob.getId(), oneJob.getName(), oneJob.getCommandExecutionDate(), exitCode, userList.get(0), message, oneJob.getJobsFile(), oneJob.getState().name(), 0L);
            } else if (this.getCompletedJobs() != null) {
                info = this.getCompletedJobForId(this.jobID);
            }
            if (info != null && !ListJobsCommand.skipJob(info.jobName)) {
                jobsToReport.add(info);
            }
        } else {
            Iterator<Job> iterator = this.jobManagerService.getJobs();
            while (iterator.hasNext()) {
                String message;
                Job job = iterator.next();
                if (!this.isJobEligible(job)) continue;
                List<String> userList = job.getSubjectUsernames();
                ActionReport actionReport = job.getActionReport();
                String string = message = actionReport == null ? "" : actionReport.getMessage();
                if (!StringUtils.ok((String)message)) {
                    message = ProgressStatusClient.composeMessageForPrint((CommandProgress)job.getCommandProgress());
                }
                String exitCode = actionReport == null ? "" : actionReport.getActionExitCode().name();
                String user = DEFAULT_USER_STRING;
                if (userList.size() > 0) {
                    user = userList.get(0);
                }
                jobsToReport.add(new JobInfo(job.getId(), job.getName(), job.getCommandExecutionDate(), exitCode, user, message, job.getJobsFile(), job.getState().name(), 0L));
            }
            JobInfos completedJobs = this.getCompletedJobs();
            if (completedJobs != null) {
                for (JobInfo info : completedJobs.getJobInfoList()) {
                    if (ListJobsCommand.skipJob(info.jobName)) continue;
                    jobsToReport.add(info);
                }
            }
        }
        return jobsToReport;
    }

    @Override
    public void execute(AdminCommandContext context) {
        this.display(AccessRequired.AccessCheck.relatedObjects(this.jobAccessChecks), context);
    }

    public static boolean skipJob(String name) {
        return name == null || "attach".equals(name) || name.startsWith("_");
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        List<JobInfo> jobInfoList = this.chooseJobs();
        for (JobInfo jobInfo : jobInfoList) {
            this.jobAccessChecks.add(new AccessRequired.AccessCheck<JobInfo>(jobInfo, "jobs/job/" + jobInfo.jobId, "read", false));
        }
        return this.jobAccessChecks;
    }

    public void display(Collection<JobInfo> jobInfoList, AdminCommandContext context) {
        this.report = context.getActionReport();
        int longestName = TITLE_NAME.length();
        int longestJobId = TITLE_JOBID.length();
        int longestTime = TITLE_TIME.length();
        int longestState = TITLE_STATE.length();
        int longestUser = TITLE_USER.length();
        int longestExitCode = TITLE_EXITCODE.length();
        for (JobInfo job : jobInfoList) {
            int jobId = job.jobId.length();
            int time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(job.commandExecutionDate).length();
            int name = job.jobName.length();
            int state = job.state.length();
            int user = job.user != null ? job.user.length() : DEFAULT_USER_STRING.length();
            int exitCode = job.exitCode.length();
            if (name > longestName) {
                longestName = name;
            }
            if (time > longestTime) {
                longestTime = time;
            }
            if (jobId > longestJobId) {
                longestJobId = jobId;
            }
            if (state > longestState) {
                longestState = state;
            }
            if (user > longestUser) {
                longestUser = user;
            }
            if (exitCode <= longestExitCode) continue;
            longestExitCode = exitCode;
        }
        if (jobInfoList.size() < 1) {
            this.report.setMessage(TITLE_NONE);
        }
        String formattedLine = "%-" + (longestName += 2) + "s %-" + (longestJobId += 2) + "s %-" + (longestTime += 2) + "s %-" + (longestState += 2) + "s %-" + (longestExitCode += 2) + "s %-" + (longestUser += 2) + "s";
        boolean first = true;
        ActionReport.MessagePart topMsg = this.report.getTopMessagePart();
        Properties properties = this.report.getExtraProperties();
        if (properties == null) {
            properties = new Properties();
            this.report.setExtraProperties(properties);
        }
        ArrayList details = new ArrayList();
        properties.put("jobs", details);
        for (JobInfo info : jobInfoList) {
            if (first) {
                topMsg.setMessage(String.format(formattedLine, TITLE_NAME, TITLE_JOBID, TITLE_TIME, TITLE_STATE, TITLE_EXITCODE, TITLE_USER));
                first = false;
            }
            ActionReport.MessagePart msg = topMsg.addChild();
            msg.setMessage(String.format(formattedLine, info.jobName, info.jobId, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(info.commandExecutionDate), info.state, info.exitCode, info.user));
            HashMap<String, Object> detail = new HashMap<String, Object>();
            details.add(detail);
            detail.put(NAME, info.jobName);
            detail.put(ID, info.jobId);
            detail.put(DATE, new Date(info.commandExecutionDate));
            if (info.commandCompletionDate == 0L) {
                detail.put(COMPLETION_DATE, " ");
            } else {
                detail.put(COMPLETION_DATE, new Date(info.commandCompletionDate));
            }
            detail.put(STATE, info.state);
            detail.put(CODE, info.exitCode);
            detail.put(MESSAGE, info.message);
            detail.put(USER, info.user);
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

