/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.bootstrap;

import com.sun.enterprise.module.bootstrap.StartupContext;
import fish.payara.boot.runtime.BootCommands;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=12)
public class BootCommandService
implements PostConstruct {
    private static final Logger LOGGER = Logger.getLogger(BootCommandService.class.getName());
    @Inject
    StartupContext startupContext;
    @Inject
    CommandRunner commandRunner;

    public void doBootCommands(String file, boolean expandValues) {
        if (file == null) {
            return;
        }
        try {
            BootCommands bootCommands = new BootCommands();
            System.out.println("Reading in commands from " + file);
            bootCommands.parseCommandScript(new File(file), expandValues);
            bootCommands.executeCommands(this.commandRunner);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error reading from file");
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public void postConstruct() {
        this.doBootCommands(this.startupContext.getArguments().getProperty("-postbootcommandfile"), true);
    }
}

