/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing;

import fish.payara.notification.requesttracing.EventType;
import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class PayaraRequestTracingProcessor
implements SpanProcessor {
    private final RequestTracingService requestTracingService;
    private ConcurrentMap<ReadableSpan, RequestTraceSpan> rootInProgressSpans = new ConcurrentHashMap<ReadableSpan, RequestTraceSpan>();
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);

    public PayaraRequestTracingProcessor(RequestTracingService requestTracingService) {
        this.requestTracingService = requestTracingService;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        if (span.getSpanContext().isSampled()) {
            if (span.getParentSpanContext().isValid()) {
                if (span.getParentSpanContext().isRemote()) {
                    RequestTraceSpan payaraSpan = PayaraRequestTracingProcessor.createSpan((ReadableSpan)span, EventType.PROPAGATED_TRACE);
                    this.rootInProgressSpans.put((ReadableSpan)span, payaraSpan);
                    this.requestTracingService.startTrace(payaraSpan);
                }
            } else {
                RequestTraceSpan payaraSpan = PayaraRequestTracingProcessor.createSpan((ReadableSpan)span, EventType.TRACE_START);
                this.requestTracingService.traceSpan(payaraSpan);
            }
        }
    }

    private static RequestTraceSpan createSpan(ReadableSpan span, EventType type) {
        return new RequestTraceSpan(type, span.getName(), PayaraRequestTracingProcessor.parseTraceId(span.getSpanContext().getTraceId()), PayaraRequestTracingProcessor.parseTraceId(span.getSpanContext().getSpanId()), RequestTraceSpan.SpanContextRelationshipType.ChildOf);
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
        if (!span.getSpanContext().isSampled()) {
            return;
        }
        SpanData data = span.toSpanData();
        RequestTraceSpan payaraSpan = (RequestTraceSpan)this.rootInProgressSpans.remove(span);
        if (payaraSpan == null) {
            payaraSpan = this.createTraceSpan(data);
        }
        this.fill(data, payaraSpan);
        this.requestTracingService.traceSpan(payaraSpan, TimeUnit.NANOSECONDS.toMillis(data.getEndEpochNanos()));
    }

    public boolean isEndRequired() {
        return true;
    }

    private RequestTraceSpan fill(SpanData data, RequestTraceSpan result) {
        result.setStartInstant(Instant.ofEpochSecond(data.getStartEpochNanos() / NANOS_PER_SECOND, data.getStartEpochNanos() % NANOS_PER_SECOND));
        result.setTraceEndTime(Instant.ofEpochSecond(data.getStartEpochNanos() / NANOS_PER_SECOND, data.getStartEpochNanos() % NANOS_PER_SECOND));
        result.setSpanDuration(data.getEndEpochNanos() - data.getStartEpochNanos());
        data.getAttributes().forEach((key, value) -> result.addSpanTag(key.getKey(), value.toString()));
        data.getEvents().forEach(ev -> result.addSpanLog(this.convert((EventData)ev)));
        return result;
    }

    private RequestTraceSpan createTraceSpan(SpanData data) {
        RequestTraceSpan result = new RequestTraceSpan(EventType.PROPAGATED_TRACE, data.getName(), this.parseTraceId(data), PayaraRequestTracingProcessor.parseTraceId(data.getSpanId()), RequestTraceSpan.SpanContextRelationshipType.ChildOf);
        return result;
    }

    private RequestTraceSpanLog convert(EventData ev) {
        RequestTraceSpanLog result = new RequestTraceSpanLog(TimeUnit.NANOSECONDS.toMillis(ev.getEpochNanos()), ev.getName());
        ev.getAttributes().forEach((k, v) -> result.addLogEntry(k.getKey(), String.valueOf(v)));
        return result;
    }

    private UUID parseTraceId(SpanData data) {
        return PayaraRequestTracingProcessor.parseTraceId(data.getTraceId());
    }

    static UUID parseTraceId(String traceId) {
        if (traceId.length() >= 32) {
            long high = PayaraRequestTracingProcessor.parseUnsignedHex(traceId, 0, 0);
            long low = PayaraRequestTracingProcessor.parseUnsignedHex(traceId, 16, 0);
            return new UUID(high, low);
        }
        long high = 0L;
        if (traceId.length() > 16) {
            high = PayaraRequestTracingProcessor.parseUnsignedHex(traceId, 0, 32 - traceId.length());
        }
        long low = PayaraRequestTracingProcessor.parseUnsignedHex(traceId, Math.max(traceId.length() - 16, 0), Math.max(16 - traceId.length(), 0));
        return new UUID(high, low);
    }

    static long parseUnsignedHex(CharSequence input, int start, int padding) {
        long result = 0L;
        int i = start;
        for (int shift = 60 - 4 * padding; shift >= 0; shift -= 4) {
            long digit = Character.digit(input.charAt(i), 16);
            result |= digit << shift;
            ++i;
        }
        return result;
    }
}

