/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jacc.provider;

import fish.payara.jacc.ContextProvider;
import fish.payara.jacc.JaccConfigurationFactory;
import fish.payara.security.jacc.provider.ContextProviderImpl;
import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContextException;
import java.security.Permission;
import java.security.Policy;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.exousia.modules.locked.SimplePolicyConfigurationFactory;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={PolicyConfigurationFactoryImpl.class, PolicyConfigurationFactory.class})
public class PolicyConfigurationFactoryImpl
extends SimplePolicyConfigurationFactory
implements JaccConfigurationFactory {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private Map<String, String> applicationToPolicyContextIdMap = new ConcurrentHashMap<String, String>();
    private Map<String, ContextProvider> contextToContextProviderMap = new ConcurrentHashMap<String, ContextProvider>();
    private Map<String, PolicyConfiguration> contextToConfigurationMap = new ConcurrentHashMap<String, PolicyConfiguration>();
    private Permission setPolicyPermission;
    private static PolicyConfigurationFactoryImpl singleton;

    public PolicyConfigurationFactoryImpl() {
        singleton = this;
    }

    static PolicyConfigurationFactoryImpl getInstance() {
        return singleton;
    }

    public void registerContextProvider(String applicationContextId, PolicyConfigurationFactory factory, Policy policy) {
        this.checkSetPolicyPermission();
        try {
            String policyContextId = this.applicationToPolicyContextIdMap.get(applicationContextId);
            if (policyContextId == null) {
                throw new IllegalStateException("No policyContextId available for applicationContextId " + applicationContextId + " Is this JaccConfigurationFactory instance used by the container?");
            }
            if (this.inService(policyContextId)) {
                throw new IllegalStateException("Context :" + policyContextId + " already has an active global provider");
            }
            ContextProvider contextProvider = this.contextToContextProviderMap.get(policyContextId);
            if (contextProvider != null && contextProvider.getPolicyConfigurationFactory().inService(policyContextId)) {
                throw new IllegalStateException("Context :" + policyContextId + " already has an active context (per app) provider");
            }
            this.contextToContextProviderMap.put(policyContextId, new ContextProviderImpl(factory, policy));
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addContextIdMapping(String applicationContextId, String policyContextId) {
        this.applicationToPolicyContextIdMap.put(applicationContextId, policyContextId);
    }

    public boolean removeContextIdMappingByPolicyContextId(String policyContextId) {
        return this.applicationToPolicyContextIdMap.entrySet().removeIf(e -> ((String)e.getValue()).equals(policyContextId));
    }

    public ContextProvider getContextProviderByPolicyContextId(String policyContextId) {
        return this.contextToContextProviderMap.get(policyContextId);
    }

    public ContextProvider removeContextProviderByPolicyContextId(String policyContextId) {
        return this.contextToContextProviderMap.remove(policyContextId);
    }

    protected List<PolicyConfiguration> getPolicyConfigurations() {
        return new ArrayList<PolicyConfiguration>(this.contextToConfigurationMap.values());
    }

    protected PolicyConfiguration removePolicyConfiguration(String contextID) {
        return this.contextToConfigurationMap.remove(contextID);
    }

    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean remove) throws PolicyContextException {
        ContextProvider contextProvider;
        this.checkSetPolicyPermission();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Getting PolicyConfiguration object with id = " + contextId);
        }
        if ((contextProvider = this.contextToContextProviderMap.get(contextId)) != null) {
            return contextProvider.getPolicyConfigurationFactory().getPolicyConfiguration(contextId, remove);
        }
        PolicyConfiguration policyConfiguration = super.getPolicyConfiguration(contextId, remove);
        this.contextToConfigurationMap.put(contextId, policyConfiguration);
        return policyConfiguration;
    }

    public boolean inService(String contextId) throws PolicyContextException {
        this.checkSetPolicyPermission();
        ContextProvider contextProvider = this.contextToContextProviderMap.get(contextId);
        if (contextProvider != null) {
            return contextProvider.getPolicyConfigurationFactory().inService(contextId);
        }
        return super.inService(contextId);
    }

    protected List<PolicyConfiguration> getPolicyConfigurationImpls() {
        return new ArrayList<PolicyConfiguration>(this.contextToConfigurationMap.values());
    }

    protected PolicyConfiguration removePolicyConfigurationImpl(String contextID) {
        return this.contextToConfigurationMap.remove(contextID);
    }

    protected void checkSetPolicyPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.setPolicyPermission == null) {
                this.setPolicyPermission = new SecurityPermission("setPolicy");
            }
            securityManager.checkPermission(this.setPolicyPermission);
        }
    }
}

