/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jacc.provider;

import fish.payara.jacc.ContextProvider;
import fish.payara.jacc.JaccConfigurationFactory;
import fish.payara.security.jacc.provider.PolicyConfigurationFactoryImpl;
import jakarta.security.jacc.PolicyContext;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Policy;
import java.security.ProtectionDomain;
import org.glassfish.exousia.modules.locked.SimplePolicyProvider;

public class PolicyProviderImpl
extends SimplePolicyProvider {
    private Policy basePolicy = Policy.getPolicy();
    private static final ThreadLocal<Object> contextProviderReentry = new ThreadLocal<Object>(){

        @Override
        protected Object initialValue() {
            return new byte[]{0};
        }
    };

    public PolicyProviderImpl() {
        if (this.basePolicy == null) {
            try {
                this.basePolicy = Policy.getInstance("JavaPolicy", null);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain domain, Permission permission) {
        byte[] alreadyCalled = (byte[])contextProviderReentry.get();
        if (alreadyCalled[0] == 1) {
            return true;
        }
        alreadyCalled[0] = 1;
        try {
            ContextProvider contextProvider;
            if (!permission.getClass().getName().startsWith("jakarta.")) {
                boolean bl = this.basePolicy.implies(domain, permission);
                return bl;
            }
            String contextId = PolicyContext.getContextID();
            if (contextId != null && (contextProvider = this.getContextProvider(contextId, this.getPolicyFactory())) != null) {
                boolean bl = contextProvider.getPolicy().implies(domain, permission);
                return bl;
            }
            boolean bl = super.implies(domain, permission);
            return bl;
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    private PolicyConfigurationFactoryImpl getPolicyFactory() {
        return PolicyConfigurationFactoryImpl.getInstance();
    }

    private ContextProvider getContextProvider(String contextId, JaccConfigurationFactory configurationFactory) {
        if (configurationFactory != null && contextId != null) {
            return configurationFactory.getContextProviderByPolicyContextId(contextId);
        }
        return null;
    }
}

